/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemUtil {
    public static final String BLOCK = "block";
    public static final String ORE = "ore";
    public static final String CLUSTER = "cluster";
    public static final String DUST = "dust";
    public static final String DUST_SMALL = "dustSmall";
    public static final String DUST_TINY = "dustTiny";
    public static final String INGOT = "ingot";
    public static final String PLATE = "plate";
    public static final String COIN = "coin";
    public static final String NUGGET = "nugget";
    public static final String LOG = "log";
    public static final String GEM = "gem";
    public static final String COVER = "cover";
    public static final String ROD = "rod";
    public static final String COMPRESSED = "compressed";
    public static final String CROP = "crop";
    private static final OreDictProxy PROXY = new OreDictProxy();
    public static final String[] ALL_TYPES = new String[]{"block", "ore", "cluster", "dust", "dustSmall", "dustTiny", "ingot", "plate", "coin", "nugget", "log", "gem", "cover", "rod", "compressed", "crop"};

    public static boolean isPlayerHoldingSomething(EntityPlayer player) {
        return !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
    }

    public static ItemStack getHeldStack(EntityPlayer player) {
        if (ItemUtil.isPlayerHoldingSomething(player)) {
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b()) {
                stack = player.func_184592_cb();
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack cloneStack(Item item) {
        return ItemUtil.cloneStack(item, 1);
    }

    public static ItemStack cloneStack(Block block) {
        return ItemUtil.cloneStack(block, 1);
    }

    public static ItemStack cloneStack(Item item, int stackSize) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, stackSize);
    }

    public static ItemStack cloneStack(Block block, int stackSize) {
        if (block == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(block, stackSize);
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.func_190920_e(stackSize);
        return retStack;
    }

    public static ItemStack cloneStack(ItemStack stack) {
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
    }

    public static ItemStack readItemStackFromNBT(NBTTagCompound nbt) {
        ItemStack stack = new ItemStack(Item.func_150899_d((int)nbt.func_74765_d("id")));
        stack.func_190920_e(nbt.func_74762_e("Count"));
        stack.func_77964_b(Math.max(0, nbt.func_74765_d("Damage")));
        if (nbt.func_150297_b("tag", 10)) {
            stack.func_77982_d(nbt.func_74775_l("tag"));
        }
        return stack;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", stack.func_190916_E());
        nbt.func_74777_a("Damage", (short)ItemUtil.getItemDamage(stack));
        if (stack.func_77942_o()) {
            nbt.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        return nbt;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, int amount, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", amount);
        nbt.func_74777_a("Damage", (short)ItemUtil.getItemDamage(stack));
        if (stack.func_77942_o()) {
            nbt.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        return nbt;
    }

    public static String getNameFromItemStack(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("display")) {
            return "";
        }
        return stack.func_77978_p().func_74775_l("display").func_74779_i("Name");
    }

    public static int getItemDamage(ItemStack stack) {
        return Items.field_151045_i.getMetadata(stack);
    }

    public static boolean hasOreDictSuffix(ItemStack stack, String oreDictSuffix) {
        return PROXY.getOreName(stack).toLowerCase().endsWith(oreDictSuffix.toLowerCase());
    }

    public static ItemStack getOre(String oreName) {
        return ItemUtil.getOre(oreName, 1);
    }

    public static ItemStack getOre(String oreName, int amount) {
        return PROXY.getOre(oreName, amount);
    }

    public static String getOreName(ItemStack stack) {
        return PROXY.getOreName(stack);
    }

    public static boolean isOreIDEqual(ItemStack stack, int oreID) {
        return PROXY.isOreIDEqual(stack, oreID);
    }

    public static boolean isOreNameEqual(ItemStack stack, String oreName) {
        return PROXY.isOreNameEqual(stack, oreName);
    }

    public static boolean oreNameExists(String oreName) {
        return PROXY.oreNameExists(oreName);
    }

    public static boolean hasOreName(ItemStack stack) {
        return !ItemUtil.getOreName(stack).equals("Unknown");
    }

    public static boolean isBlock(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(BLOCK);
    }

    public static boolean isOre(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(ORE);
    }

    public static boolean isCluster(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(CLUSTER);
    }

    public static boolean isDust(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(DUST);
    }

    public static boolean isIngot(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(INGOT);
    }

    public static boolean isPlate(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(PLATE);
    }

    public static boolean isCoin(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(COIN);
    }

    public static boolean isNugget(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(NUGGET);
    }

    public static boolean isLog(ItemStack stack) {
        return ItemUtil.getOreName(stack).startsWith(LOG);
    }

    public static boolean doOreIDsMatch(ItemStack stackA, ItemStack stackB) {
        int id = PROXY.getOreID(stackA);
        return id >= 0 && id == PROXY.getOreID(stackB);
    }

    public static NonNullList<ItemStack> getOres(String oreName) {
        return PROXY.getOres(oreName);
    }

    public static NonNullList<ItemStack> getOresThatContain(String oreName) {
        return PROXY.getOres(oreName);
    }

    static class OreDictProxy {
        OreDictProxy() {
        }

        public ItemStack getOre(String oreName, int amount) {
            if (!this.oreNameExists(oreName)) {
                return ItemStack.field_190927_a;
            }
            return ItemUtil.cloneStack((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0), amount);
        }

        public NonNullList<ItemStack> getOres(String oreName) {
            if (!this.oreNameExists(oreName)) {
                return NonNullList.func_191196_a();
            }
            return OreDictionary.getOres((String)oreName, (boolean)false);
        }

        public int getOreID(ItemStack stack) {
            return this.getOreID(this.getOreName(stack));
        }

        public int getOreID(String oreName) {
            if (Strings.isNullOrEmpty((String)oreName)) {
                return -1;
            }
            return OreDictionary.getOreID((String)oreName);
        }

        public List<Integer> getAllOreIDs(ItemStack stack) {
            return Ints.asList((int[])OreDictionary.getOreIDs((ItemStack)stack));
        }

        public String getOreName(ItemStack stack) {
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            if (ids != null && ids.length >= 1) {
                return OreDictionary.getOreName((int)ids[0]);
            }
            return "";
        }

        public String getOreName(int oreID) {
            return OreDictionary.getOreName((int)oreID);
        }

        public boolean isOreIDEqual(ItemStack stack, int oreID) {
            return this.getOreID(stack) == oreID;
        }

        public boolean isOreNameEqual(ItemStack stack, String oreName) {
            return OreDictionary.getOreName((int)this.getOreID(stack)).equals(oreName);
        }

        public boolean oreNameExists(String oreName) {
            return OreDictionary.doesOreNameExist((String)oreName) && OreDictionary.getOres((String)oreName, (boolean)false).size() > 0;
        }
    }
}

