/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.annotations.ForRemoval;
import micdoodle8.mods.galacticraft.annotations.ReplaceWith;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine2;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileEntityOxygenStorageModule
extends TileEntityOxygen
implements IInventoryDefaults,
ISidedInventory,
IMachineSides {
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledOxygenLevel;
    private int lastScaledOxygenLevel;
    public static final int OUTPUT_PER_TICK = 500;
    public static final int OXYGEN_CAPACITY = 60000;
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityOxygenStorageModule() {
        super("tile.machine2.6.name", 60000, 40);
        this.storage.setCapacity(0.0f);
        this.storage.setMaxExtract(0.0f);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_73660_a() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(0)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            int oxygenDraw = (int)Math.floor(Math.min((float)this.oxygenPerTick * 2.5f, (float)(this.getMaxOxygenStored() - this.getOxygenStored())));
            this.setOxygenStored(this.getOxygenStored() + oxygenItem.discharge(oxygenItemStack, oxygenDraw));
            if (this.getOxygenStored() > this.getMaxOxygenStored()) {
                this.setOxygenStored(this.getOxygenStored());
            }
        }
        super.func_73660_a();
        this.scaledOxygenLevel = this.getScaledOxygenLevel(16);
        if (this.scaledOxygenLevel != this.lastScaledOxygenLevel) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
        }
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
        this.produceOxygen(this.byIndex().func_176746_e().func_176734_d());
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readMachineSidesFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.addMachineSidesToNBT(nbt);
        return nbt;
    }

    @Override
    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public boolean shouldPullEnergy() {
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return false;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return null;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public int getOxygenProvide(EnumFacing direction) {
        return this.getOxygenOutputDirections().contains(direction) ? Math.min(500, this.getOxygenStored()) : 0;
    }

    @Override
    public EnumFacing byIndex() {
        return BlockMachineBase.byIndex(this.field_145850_b.func_180495_p(this.func_174877_v()));
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && itemstack != null && itemstack.func_77973_b() instanceof IItemOxygenSupply;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    @Override
    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0 && this.func_94041_b(slotID, itemstack)) {
            return itemstack.func_77952_i() < itemstack.func_77973_b().func_77612_l();
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0 && !itemstack.func_190926_b()) {
            return FluidUtil.isEmptyContainer(itemstack);
        }
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return super.canDrain(from, fluid);
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return super.drain(from, resource, doDrain);
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return super.drain(from, maxDrain, doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return super.canFill(from, fluid);
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return super.fill(from, resource, doFill);
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return super.getTankInfo(from);
    }

    @Override
    public EnumSet<EnumFacing> getOxygenInputDirections() {
        EnumFacing dir;
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case REAR: {
                dir = this.byIndex().func_176734_d();
                break;
            }
            case TOP: {
                dir = EnumFacing.UP;
                break;
            }
            case BOTTOM: {
                dir = EnumFacing.DOWN;
                break;
            }
            case RIGHT: {
                dir = this.byIndex().func_176735_f();
                break;
            }
            default: {
                dir = this.byIndex().func_176746_e();
            }
        }
        return EnumSet.of(dir);
    }

    @Override
    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        EnumFacing dir;
        switch (this.getSide(IMachineSides.MachineSide.PIPE_OUT)) {
            case REAR: {
                dir = this.byIndex().func_176734_d();
                break;
            }
            case TOP: {
                dir = EnumFacing.UP;
                break;
            }
            case BOTTOM: {
                dir = EnumFacing.DOWN;
                break;
            }
            case LEFT: {
                dir = this.byIndex().func_176746_e();
                break;
            }
            default: {
                dir = this.byIndex().func_176735_f();
            }
        }
        return EnumSet.of(dir);
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN, IMachineSides.MachineSide.PIPE_OUT};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT, IMachineSides.Face.RIGHT};
    }

    @Override
    public synchronized IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return BlockMachine2.MACHINESIDES_RENDERTYPE;
    }

    @Override
    @Deprecated
    @ForRemoval(deadline="4.1.0")
    @ReplaceWith(value="byIndex()")
    public EnumFacing getFront() {
        return this.byIndex();
    }
}

