/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.annotations.ForRemoval;
import micdoodle8.mods.galacticraft.annotations.ReplaceWith;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.blocks.BlockOxygenCompressor;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class TileEntityOxygenCompressor
extends TileEntityOxygen {
    public static final int TANK_TRANSFER_SPEED = 2;
    private boolean usingEnergy = false;

    public TileEntityOxygenCompressor() {
        super("container.oxygencompressor.name", 1200, 16);
        this.storage.setMaxExtract(15.0f);
        this.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_73660_a() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(2)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            int oxygenDraw = (int)Math.floor(Math.min((float)this.oxygenPerTick * 2.5f, (float)(this.getMaxOxygenStored() - this.getOxygenStored())));
            this.setOxygenStored(this.getOxygenStored() + oxygenItem.discharge(oxygenItemStack, oxygenDraw));
            if (this.getOxygenStored() > this.getMaxOxygenStored()) {
                this.setOxygenStored(this.getOxygenStored());
            }
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack tank0;
            this.usingEnergy = false;
            if (this.getOxygenStored() > 0 && this.hasEnoughEnergyToRun && !(tank0 = (ItemStack)this.getInventory().get(0)).func_190926_b() && tank0.func_77973_b() instanceof ItemOxygenTank && tank0.func_77952_i() > 0) {
                tank0.func_77964_b(tank0.func_77952_i() - 2);
                this.setOxygenStored(this.getOxygenStored() - 2);
                this.usingEnergy = true;
            }
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    @Override
    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77952_i() > 1;
                }
                case 1: {
                    return ItemElectricBase.isElectricItemCharged(itemstack);
                }
                case 2: {
                    return itemstack.func_77952_i() < itemstack.func_77973_b().func_77612_l();
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof ItemOxygenTank && itemstack.func_77952_i() == 0;
            }
            case 1: {
                return ItemElectricBase.isElectricItemEmpty(itemstack);
            }
            case 2: {
                return FluidUtil.isEmptyContainer(itemstack);
            }
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof ItemOxygenTank;
            }
            case 1: {
                return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            case 2: {
                return itemstack.func_77973_b() instanceof IItemOxygenSupply;
            }
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.usingEnergy;
    }

    @Override
    public EnumFacing byIndex() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockOxygenCompressor) {
            return ((EnumFacing)state.func_177229_b((IProperty)BlockOxygenCompressor.FACING)).func_176746_e();
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.byIndex();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(1);
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public EnumSet<EnumFacing> getOxygenInputDirections() {
        return EnumSet.of(this.getElectricInputDirection().func_176734_d());
    }

    @Override
    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    @Deprecated
    @ForRemoval(deadline="4.1.0")
    @ReplaceWith(value="byIndex()")
    public EnumFacing getFront() {
        return this.byIndex();
    }
}

