/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.entity;

import icbm.classic.api.data.IWorldPosition;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.transform.vector.Pos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityICBM
extends Entity
implements IWorldPosition {
    protected boolean hasHealth = false;
    private static final DataParameter<Float> HEALTH = EntityDataManager.func_187226_a(EntityICBM.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAX_HEALTH = EntityDataManager.func_187226_a(EntityICBM.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final NbtSaveHandler<EntityICBM> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeFloat("health", EntityICBM::getHealth, EntityICBM::setHealth).nodeFloat("health_max", EntityICBM::getMaxHealth, EntityICBM::setMaxHealth).base();

    public EntityICBM(World world) {
        super(world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(MAX_HEALTH, (Object)Float.valueOf(1.0f));
    }

    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(HEALTH)).floatValue();
    }

    public <T> T setHealth(float health) {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Float.valueOf(MathHelper.func_76131_a((float)health, (float)0.0f, (float)this.getMaxHealth())));
        return (T)this;
    }

    public float getMaxHealth() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_HEALTH)).floatValue();
    }

    public <T> T setMaxHealth(float hp) {
        this.field_70180_af.func_187227_b(MAX_HEALTH, (Object)Float.valueOf(hp));
        return (T)this;
    }

    public <T> T initHealth(float hp) {
        this.setMaxHealth(hp);
        this.setHealth(hp);
        return (T)this;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.hasHealth && damage > 0.0f && this.canDamage(this, source)) {
            this.setHealth(Math.max(this.getHealth() - damage, 0.0f));
            if (this.getHealth() <= 0.0f) {
                this.onDestroyedBy(source, damage);
            }
            return true;
        }
        return false;
    }

    public boolean canDamage(Entity entity, DamageSource source) {
        if (!entity.func_180431_b(source) && entity.func_70089_S()) {
            return !(entity instanceof EntityLivingBase) || !(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75098_d;
        }
        return false;
    }

    protected void onDestroyedBy(DamageSource source, float damage) {
        this.destroy();
    }

    protected void destroy() {
        this.func_70106_y();
    }

    protected void alignToBounds() {
        this.field_70165_t = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
        this.field_70163_u = this.func_174813_aQ().field_72338_b + this.func_70033_W() - (double)this.field_70131_O;
        this.field_70161_v = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
    }

    public Vec3d getPredictedPosition(int t) {
        return new Vec3d(this.field_70165_t + this.field_70159_w * (double)t, this.field_70163_u + this.field_70181_x * (double)t, this.field_70161_v + this.field_70179_y * (double)t);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
    }

    @Override
    public World world() {
        return this.field_70170_p;
    }

    @Override
    public double x() {
        return this.field_70165_t;
    }

    @Override
    public double y() {
        return this.field_70163_u;
    }

    @Override
    public double z() {
        return this.field_70161_v;
    }

    public Pos getVelocity() {
        return new Pos(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double xx, double yy, double zz) {
        this.setMotionVector(xx, yy, zz);
    }

    public void setMotionVector(double xx, double yy, double zz) {
        this.field_70159_w = xx;
        this.field_70181_x = yy;
        this.field_70179_y = zz;
    }
}

