/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.transform.region;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.lib.transform.rotation.EulerAngle;
import icbm.classic.lib.transform.vector.Pos;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public abstract class Shape3D {
    EulerAngle angle;
    Pos center;

    public Shape3D(Pos center) {
        this.center = center;
    }

    public Shape3D(NBTTagCompound nbt) {
        this(new Pos(nbt.func_74775_l("center")));
        this.angle = new EulerAngle(nbt.func_74769_h("yaw"), nbt.func_74769_h("pitch"), nbt.func_74769_h("roll"));
    }

    abstract boolean isWithin(double var1, double var3, double var5);

    abstract double getVolume();

    abstract double getArea();

    abstract double getSizeX();

    abstract double getSizeY();

    abstract double getSizeZ();

    double getSize() {
        double r = this.getSizeX();
        if (this.getSizeY() > r) {
            r = this.getSizeY();
        }
        if (this.getSizeZ() > r) {
            r = this.getSizeZ();
        }
        return r;
    }

    public IPos3D getCenter() {
        return this.center;
    }

    public double distance(IPos3D pos) {
        return this.center.distance(pos);
    }

    public boolean isWithin(IPos3D vec) {
        return this.isWithin(vec.x(), vec.y(), vec.z());
    }

    public boolean isWithin(BlockPos vec) {
        return this.isWithin(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }
}

