/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tracker;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.tracker.EventTrackerEntry;
import icbm.classic.lib.tracker.EventTrackerType;
import icbm.classic.lib.tracker.IEventTrackerListener;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;

public class ListenerEntry
implements IEventTrackerListener {
    public final ResourceLocation name;
    public final IEventTrackerListener listener;
    public final Supplier<Boolean> conditional;

    public ListenerEntry(ResourceLocation name, IEventTrackerListener listener) {
        this.name = name;
        this.listener = listener;
        this.conditional = () -> true;
    }

    public ListenerEntry(ResourceLocation name, IEventTrackerListener listener, Supplier<Boolean> conditional) {
        this.name = name;
        this.listener = listener;
        this.conditional = conditional;
    }

    @Override
    public void accept(EventTrackerEntry entry) {
        try {
            this.listener.accept(entry);
        }
        catch (Exception e) {
            ICBMClassic.logger().error(String.format("Listener(%s): error while handling entry(%s)", this.name, entry.getType()));
        }
    }

    @Override
    public boolean consumes(EventTrackerType type) {
        return this.conditional.get() != false && this.listener.consumes(type);
    }

    @Generated
    public ResourceLocation getName() {
        return this.name;
    }

    @Generated
    public IEventTrackerListener getListener() {
        return this.listener;
    }

    @Generated
    public Supplier<Boolean> getConditional() {
        return this.conditional;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListenerEntry)) {
            return false;
        }
        ListenerEntry other = (ListenerEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResourceLocation this$name = this.getName();
        ResourceLocation other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        IEventTrackerListener this$listener = this.getListener();
        IEventTrackerListener other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        Supplier<Boolean> this$conditional = this.getConditional();
        Supplier<Boolean> other$conditional = other.getConditional();
        return !(this$conditional == null ? other$conditional != null : !this$conditional.equals(other$conditional));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ListenerEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResourceLocation $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        IEventTrackerListener $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        Supplier<Boolean> $conditional = this.getConditional();
        result = result * 59 + ($conditional == null ? 43 : $conditional.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ListenerEntry(name=" + this.getName() + ", listener=" + this.getListener() + ", conditional=" + this.getConditional() + ")";
    }
}

