/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tracker;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.tracker.EventTrackerData;
import icbm.classic.lib.tracker.EventTrackerEntry;
import icbm.classic.lib.tracker.EventTrackerType;
import icbm.classic.lib.tracker.IEventTrackerListener;
import icbm.classic.lib.tracker.ListenerEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;

public class EventTracker {
    private final List<ListenerEntry> listeners = new ArrayList<ListenerEntry>();
    private final EventTrackerData eventTrackerData = new EventTrackerData().initDefaults();

    public EventTracker listen(ResourceLocation name, IEventTrackerListener listener) {
        this.listeners.add(new ListenerEntry(name, listener));
        return this;
    }

    public void post(EventTrackerType type, Supplier<Boolean> condition, Supplier<Object[]> data) {
        if (condition.get().booleanValue()) {
            this.post(type, data);
        }
    }

    public void post(EventTrackerType type, Supplier<Object[]> supplier) {
        Object[] data;
        if (this.consumes(type) && this.isDataReadOnly(type, data = supplier.get())) {
            this.post(new EventTrackerEntry(type, data));
        }
    }

    public void post(EventTrackerEntry entry) {
        this.post(entry, this.listeners);
        this.post(entry, entry.getType().getListeners());
    }

    protected void post(EventTrackerEntry entry, List<ListenerEntry> listeners) {
        for (IEventTrackerListener iEventTrackerListener : listeners) {
            if (!iEventTrackerListener.consumes(entry.getType())) continue;
            iEventTrackerListener.accept(entry);
        }
    }

    protected final boolean isDataReadOnly(EventTrackerType type, Object[] data) {
        boolean good = true;
        for (Object object : data) {
            if (object == null || this.eventTrackerData.isValidType(object.getClass())) continue;
            good = false;
            ICBMClassic.logger().warn(String.format("EventTracker(%s): Class['%s'] is not supported for use with events.", type.getName(), object.getClass()));
        }
        if (!good) {
            String msg = String.format("EventTracker(%s): Ignoring event due to containing editable fields. Supplying said fields could result in listeners incorrectly editing the game state", type.getName());
            ICBMClassic.logger().error(msg, (Throwable)new RuntimeException("Dev Bug, likely caused by domain '" + type.getName().func_110624_b() + "' but may be another mod using the domain incorrectly"));
        }
        return good;
    }

    public boolean consumes(EventTrackerType type) {
        if (this.listeners.isEmpty() && type.getListeners().isEmpty()) {
            return false;
        }
        for (IEventTrackerListener iEventTrackerListener : type.getListeners()) {
            if (!iEventTrackerListener.consumes(type)) continue;
            return true;
        }
        for (IEventTrackerListener iEventTrackerListener : this.listeners) {
            if (!iEventTrackerListener.consumes(type)) continue;
            return true;
        }
        return false;
    }
}

