/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.radio;

import com.google.common.collect.Lists;
import icbm.classic.ICBMClassic;
import icbm.classic.api.data.IBoundBox;
import icbm.classic.api.radio.IRadio;
import icbm.classic.api.radio.IRadioMessage;
import icbm.classic.api.radio.IRadioReceiver;
import icbm.classic.api.radio.IRadioSender;
import icbm.classic.lib.radio.RadioRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class RadioMap {
    protected final int dimID;
    protected HashMap<ChunkPos, List<IRadioReceiver>> chunk_to_entities = new HashMap();
    protected HashMap<IRadioReceiver, List<ChunkPos>> receive_to_chunks = new HashMap();
    protected HashMap<IRadioSender, List<IRadioReceiver>> sender_to_receivers_cache = new HashMap();
    protected HashMap<IRadioReceiver, IBoundBox<BlockPos>> receive_to_range = new HashMap();
    protected List<IRadioReceiver> fullMapRangeReceives = new ArrayList<IRadioReceiver>();

    public RadioMap(int dimID) {
        this.dimID = dimID;
    }

    public boolean add(IRadioReceiver receiver) {
        if (receiver.getWorld() == null || receiver.getWorld().field_72995_K) {
            return false;
        }
        IBoundBox<BlockPos> range = receiver.getRange();
        if (range != null) {
            if (range == RadioRegistry.INFINITE) {
                if (!this.fullMapRangeReceives.contains(receiver)) {
                    this.fullMapRangeReceives.add(receiver);
                }
                return true;
            }
            if (!this.receive_to_chunks.containsKey(receiver)) {
                this.updateChunkCache(receiver, range);
                this.updateSenderCache(receiver, range);
                return true;
            }
        }
        return false;
    }

    public static List<ChunkPos> getChunkCoords(IBoundBox<BlockPos> range) {
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        for (int chunkX = (range.lowerBound().func_177958_n() >> 4) - 1; chunkX <= (range.upperBound().func_177958_n() >> 4) + 1; ++chunkX) {
            for (int chunkZ = (range.lowerBound().func_177952_p() >> 4) - 1; chunkZ <= (range.upperBound().func_177952_p() >> 4) + 1; ++chunkZ) {
                chunks.add(new ChunkPos(chunkX, chunkZ));
            }
        }
        return chunks;
    }

    public static boolean doesOverlap(IBoundBox<BlockPos> self, IBoundBox<BlockPos> box) {
        return !RadioMap.isOutSide(box.lowerBound().func_177958_n(), box.upperBound().func_177958_n(), self.lowerBound().func_177958_n(), self.upperBound().func_177958_n()) || !RadioMap.isOutSide(box.lowerBound().func_177956_o(), box.upperBound().func_177956_o(), self.lowerBound().func_177956_o(), self.upperBound().func_177956_o()) || !RadioMap.isOutSide(box.lowerBound().func_177952_p(), box.upperBound().func_177952_p(), self.lowerBound().func_177952_p(), self.upperBound().func_177952_p());
    }

    public static boolean isOutSide(int boxMin, int boxMax, int selfMin, int selfMax) {
        return selfMin > boxMin || boxMax > selfMax;
    }

    protected void updateChunkCache(IRadioReceiver receiver, IBoundBox<BlockPos> range) {
        List<ChunkPos> list = RadioMap.getChunkCoords(range);
        for (ChunkPos pair : list) {
            List<IRadioReceiver> receivers = this.chunk_to_entities.get(pair);
            if (receivers == null) {
                receivers = new ArrayList<IRadioReceiver>();
            }
            if (!receivers.contains(receiver)) {
                receivers.add(receiver);
            }
            this.chunk_to_entities.put(pair, receivers);
        }
        this.receive_to_chunks.put(receiver, list);
    }

    protected void updateSenderCache(IRadioReceiver receiver, IBoundBox<BlockPos> range) {
        if (range != null) {
            for (IRadioSender sender : this.sender_to_receivers_cache.keySet()) {
                IBoundBox<BlockPos> senderRange = sender.getRange();
                if (!RadioMap.doesOverlap(senderRange, range)) continue;
                List<IRadioReceiver> receivers = this.sender_to_receivers_cache.get(sender);
                if (receivers == null) {
                    receivers = new ArrayList<IRadioReceiver>();
                }
                if (!receivers.contains(receiver)) {
                    receivers.add(receiver);
                }
                this.sender_to_receivers_cache.put(sender, receivers);
            }
        }
    }

    public void update(IRadioReceiver receiver) {
        IBoundBox<BlockPos> range;
        if ((!this.receive_to_range.containsKey(receiver) || this.receive_to_range.get(receiver) == null || this.receive_to_range.get(receiver).equals(receiver.getRange())) && (range = receiver.getRange()) != null) {
            this.updateChunkCache(receiver, range);
            this.updateSenderCache(receiver, range);
        }
    }

    public boolean remove(IRadioReceiver receiver) {
        if (receiver.getWorld() == null || receiver.getWorld().field_72995_K) {
            return false;
        }
        if (this.fullMapRangeReceives.contains(receiver)) {
            this.fullMapRangeReceives.remove(receiver);
        }
        if (this.receive_to_chunks.containsKey(receiver)) {
            for (ChunkPos pair : this.receive_to_chunks.get(receiver)) {
                if (!this.chunk_to_entities.containsKey(pair)) continue;
                this.chunk_to_entities.get(pair).remove(receiver);
            }
            this.receive_to_chunks.remove(receiver);
            for (IRadioSender sender : this.sender_to_receivers_cache.keySet()) {
                List<IRadioReceiver> receivers = this.sender_to_receivers_cache.get(sender);
                if (receivers == null) {
                    receivers = new ArrayList<IRadioReceiver>();
                }
                if (receivers.contains(receiver)) {
                    receivers.remove(receiver);
                }
                this.sender_to_receivers_cache.put(sender, receivers);
            }
            return true;
        }
        return false;
    }

    public void popMessage(IRadioSender sender, IRadioMessage packet) {
        block10: {
            if (packet == null || packet.getChannel() == null || packet.getChannel().trim().isEmpty() || sender == null) {
                ICBMClassic.logger().error("RadarMap[" + this.dimID + "]: Invalid radio message " + sender + " " + packet, (Throwable)new RuntimeException());
                return;
            }
            if (this.sender_to_receivers_cache.containsKey(sender)) {
                for (IRadioReceiver receiver : this.sender_to_receivers_cache.get(sender)) {
                    receiver.onMessage(sender, packet);
                }
                return;
            }
            for (int i = this.fullMapRangeReceives.size() - 1; i >= 0; --i) {
                this.fullMapRangeReceives.get(i).onMessage(sender, packet);
            }
            IBoundBox<BlockPos> senderRange = sender.getRange();
            if (senderRange == null) break block10;
            if (this.receive_to_chunks.size() < 200 || senderRange.upperBound().func_177958_n() - senderRange.lowerBound().func_177958_n() > 320 || senderRange.upperBound().func_177952_p() - senderRange.lowerBound().func_177952_p() > 320) {
                for (IRadioReceiver receiver : this.receive_to_chunks.keySet()) {
                    IBoundBox<BlockPos> receiverRange;
                    if (receiver == null || receiver == sender || !RadioMap.doesOverlap(senderRange, receiverRange = receiver.getRange()) && !RadioMap.doesOverlap(receiverRange, senderRange)) continue;
                    receiver.onMessage(sender, packet);
                }
            } else {
                List<ChunkPos> coords = RadioMap.getChunkCoords(senderRange);
                ArrayList<IRadioReceiver> receivers = new ArrayList<IRadioReceiver>();
                for (ChunkPos pair : coords) {
                    List<IRadioReceiver> l = this.chunk_to_entities.get(pair);
                    if (l == null || l.size() <= 0) continue;
                    for (IRadioReceiver r : l) {
                        if (r == null || r == sender || receivers.contains(r)) continue;
                        receivers.add(r);
                    }
                }
                for (IRadioReceiver receiver : receivers) {
                    receiver.onMessage(sender, packet);
                }
            }
        }
    }

    public void updateCache(IRadioSender sender) {
        this.sender_to_receivers_cache.remove(sender);
        IBoundBox<BlockPos> range = sender.getRange();
        if (range != null) {
            this.sender_to_receivers_cache.put(sender, this.getReceiversInRange(range, sender instanceof IRadioReceiver ? (IRadioReceiver)((Object)sender) : (IRadioReceiver)null));
        }
    }

    public List<IRadioReceiver> getReceiversInRange(IBoundBox<BlockPos> range, IRadioReceiver exclude) {
        return this.getReceiversInRange(range, exclude != null ? Lists.newArrayList((Object[])new IRadio[]{exclude}) : null);
    }

    public List<IRadioReceiver> getReceiversInRange(IBoundBox<BlockPos> range, List<IRadio> excludeList) {
        ArrayList<IRadioReceiver> receivers = new ArrayList<IRadioReceiver>();
        receivers.addAll(this.fullMapRangeReceives);
        if (range != null) {
            for (IRadioReceiver receiver : this.receive_to_chunks.keySet()) {
                IBoundBox<BlockPos> receiverRange;
                if (receiver == null || excludeList != null && excludeList.contains(receiver) || (receiverRange = receiver.getRange()) == null || !RadioMap.doesOverlap(range, receiverRange)) continue;
                receivers.add(receiver);
            }
        }
        return receivers;
    }

    protected final ChunkPos getChunkValue(int x, int z) {
        return new ChunkPos(x >> 4, z >> 4);
    }

    public void unloadAll() {
        this.chunk_to_entities.clear();
    }

    public int dimID() {
        return this.dimID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RadioMap) {
            return ((RadioMap)object).dimID == this.dimID;
        }
        return false;
    }

    public String toString() {
        return "RadioMap[" + this.dimID + "]";
    }
}

