/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.projectile.vanilla;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.projectile.IProjectileData;
import icbm.classic.api.missiles.projectile.IProjectileDataRegistry;
import icbm.classic.lib.buildable.BuildableObject;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntitySpawnProjectileData
extends BuildableObject<EntitySpawnProjectileData, IProjectileDataRegistry>
implements IProjectileData<Entity> {
    public static final ResourceLocation NAME = new ResourceLocation("minecraft", "entity");
    private ResourceLocation entityKey;
    private String entityDisplayTag;
    private NBTTagCompound entityData;
    private static final NbtSaveHandler<EntitySpawnProjectileData> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeResourceLocation("entity_id", e -> e.entityKey, (e, r) -> {
        e.entityKey = r;
    }).nodeString("custom_name", EntitySpawnProjectileData::getEntityDisplayTag, EntitySpawnProjectileData::setEntityDisplayTag).nodeCompoundTag("entity_data", EntitySpawnProjectileData::getEntityData, EntitySpawnProjectileData::setEntityData).base();

    public EntitySpawnProjectileData() {
        super(NAME, ICBMClassicAPI.PROJECTILE_DATA_REGISTRY, SAVE_LOGIC);
    }

    public EntitySpawnProjectileData(ResourceLocation key) {
        this();
        this.entityKey = key;
    }

    public EntitySpawnProjectileData(String name) {
        this(new ResourceLocation(name));
    }

    @Override
    public Entity newEntity(World world, boolean allowItemPickup) {
        EntityEntry entry;
        if (this.entityKey != null && (entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.entityKey)) != null) {
            Entity entity = entry.newInstance(world);
            if (entity != null) {
                if (this.entityDisplayTag != null) {
                    entity.func_96094_a(this.entityDisplayTag);
                }
                if (this.entityData != null) {
                    NBTTagCompound entityExistingSave = entity.func_189511_e(new NBTTagCompound());
                    UUID uuid = entity.func_110124_au();
                    entityExistingSave.func_179237_a(this.entityData);
                    entity.func_184221_a(uuid);
                    entity.func_70020_e(entityExistingSave);
                }
            }
            return entity;
        }
        return null;
    }

    @Generated
    public String getEntityDisplayTag() {
        return this.entityDisplayTag;
    }

    @Generated
    public EntitySpawnProjectileData setEntityDisplayTag(String entityDisplayTag) {
        this.entityDisplayTag = entityDisplayTag;
        return this;
    }

    @Generated
    public NBTTagCompound getEntityData() {
        return this.entityData;
    }

    @Generated
    public EntitySpawnProjectileData setEntityData(NBTTagCompound entityData) {
        this.entityData = entityData;
        return this;
    }
}

