/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.lambda.tile;

import icbm.classic.lib.network.lambda.PacketCodex;
import icbm.classic.lib.network.lambda.tile.PacketLambdaTile;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class PacketCodexTile<R extends TileEntity, T>
extends PacketCodex<R, T> {
    public PacketCodexTile(ResourceLocation parent, String name, Function<R, T> converter) {
        this(parent, new ResourceLocation("icbmclassic", name), converter);
    }

    public PacketCodexTile(ResourceLocation parent, ResourceLocation name, Function<R, T> converter) {
        super(parent, name, converter);
    }

    public PacketCodexTile(ResourceLocation parent, ResourceLocation name) {
        this(parent, name, (R tile) -> tile);
    }

    public PacketCodexTile(ResourceLocation parent, String name) {
        this(parent, new ResourceLocation(parent.func_110624_b(), name));
    }

    public void sendToAllAround(R tile) {
        double range = 64.0;
        if (tile.func_145831_w() instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)tile.func_145831_w();
            range = Optional.ofNullable(worldServer.func_73046_m()).map(MinecraftServer::func_184103_al).map(PlayerList::func_72395_o).map(d -> (double)(d * 16) + 1.0).orElse(range);
        }
        this.sendToAllAround(tile, range);
    }

    public void sendToAllAround(R tile, double range) {
        super.sendToAllAround(tile, new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), range));
    }

    @Override
    public boolean isValid(TileEntity tile) {
        return tile != null && !tile.func_145837_r();
    }

    public PacketLambdaTile<T> build(R tile) {
        return new PacketLambdaTile(this, (TileEntity)tile, this.getConverter().apply(tile));
    }
}

