/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.lambda;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.lambda.PacketCodexEntry;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.util.TriConsumer;

public abstract class PacketCodex<RAW, TARGET> {
    public static final String LOGGER_TEMPLATE = "Packet(%s): %s\n\tWorld:%s\n\tPos: %sx %sy %sz\n\n\tCodex: %s\n\tParent: %s\n\tName: %s";
    private int id = -1;
    private boolean allowServer = true;
    private boolean allowClient = true;
    private final ResourceLocation parent;
    private final ResourceLocation name;
    private final Function<RAW, TARGET> converter;
    private final List<PacketCodexEntry<TARGET, ?>> entries = new ArrayList();
    private TriConsumer<RAW, TARGET, EntityPlayer> onFinished;

    public PacketCodex<RAW, TARGET> asClientOnly() {
        this.allowClient = true;
        this.allowServer = false;
        return this;
    }

    public PacketCodex<RAW, TARGET> asServerOnly() {
        this.allowClient = false;
        this.allowServer = true;
        return this;
    }

    public PacketCodex<RAW, TARGET> fromClient() {
        return this.asServerOnly();
    }

    public PacketCodex<RAW, TARGET> fromServer() {
        return this.asClientOnly();
    }

    public PacketCodex<RAW, TARGET> nodeInt(Function<TARGET, Integer> getter, BiConsumer<TARGET, Integer> setter) {
        return this.node(Integer.class, false, getter, setter, ByteBuf::writeInt, ByteBuf::readInt);
    }

    public PacketCodex<RAW, TARGET> nodeByte(Function<TARGET, Byte> getter, BiConsumer<TARGET, Byte> setter) {
        this.entries.add(new PacketCodexEntry<TARGET, Byte>((Type)((Object)Byte.class), false, getter, setter, ByteBuf::writeByte, ByteBuf::readByte));
        return this;
    }

    public <E extends Enum<E>> PacketCodex<RAW, TARGET> nodeEnum(Class<E> e, Function<TARGET, E> getter, BiConsumer<TARGET, E> setter) {
        if (((Enum[])e.getEnumConstants()).length > 255) {
            return this.nodeInt(t -> ((Enum)getter.apply(t)).ordinal(), (t, v) -> setter.accept(t, ((Enum[])e.getEnumConstants())[v]));
        }
        return this.nodeByte(t -> (byte)((Enum)getter.apply(t)).ordinal(), (t, v) -> setter.accept(t, ((Enum[])e.getEnumConstants())[v]));
    }

    public PacketCodex<RAW, TARGET> nodeFacing(Function<TARGET, EnumFacing> getter, BiConsumer<TARGET, EnumFacing> setter) {
        return this.node(EnumFacing.class, false, getter, setter, (byteBuf, face) -> byteBuf.writeByte((int)((byte)face.ordinal())), byteBuf -> EnumFacing.func_82600_a((int)byteBuf.readByte()));
    }

    public PacketCodex<RAW, TARGET> nodeDouble(Function<TARGET, Double> getter, BiConsumer<TARGET, Double> setter) {
        return this.node(Double.class, false, getter, setter, ByteBuf::writeDouble, ByteBuf::readDouble);
    }

    public PacketCodex<RAW, TARGET> nodeFloat(Function<TARGET, Float> getter, BiConsumer<TARGET, Float> setter) {
        return this.node(Float.class, false, getter, setter, ByteBuf::writeFloat, ByteBuf::readFloat);
    }

    public PacketCodex<RAW, TARGET> nodeString(Function<TARGET, String> getter, BiConsumer<TARGET, String> setter) {
        return this.node(String.class, false, getter, setter, ByteBufUtils::writeUTF8String, ByteBufUtils::readUTF8String);
    }

    public PacketCodex<RAW, TARGET> nodeItemStack(Function<TARGET, ItemStack> getter, BiConsumer<TARGET, ItemStack> setter) {
        return this.node(ItemStack.class, false, getter, setter, ByteBufUtils::writeItemStack, ByteBufUtils::readItemStack);
    }

    public PacketCodex<RAW, TARGET> nodeVec3d(Function<TARGET, Vec3d> getter, BiConsumer<TARGET, Vec3d> setter) {
        this.entries.add(new PacketCodexEntry<TARGET, Vec3d>((Type)((Object)Vec3d.class), false, getter, setter, (byteBuf, vec3d) -> {
            byteBuf.writeDouble(vec3d.field_72450_a);
            byteBuf.writeDouble(vec3d.field_72448_b);
            byteBuf.writeDouble(vec3d.field_72449_c);
        }, byteBuf -> new Vec3d(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble())));
        return this;
    }

    public PacketCodex<RAW, TARGET> nodeNbtCompound(Function<TARGET, NBTTagCompound> getter, BiConsumer<TARGET, NBTTagCompound> setter) {
        return this.node(NBTTagCompound.class, false, getter, setter, ByteBufUtils::writeTag, ByteBufUtils::readTag);
    }

    public PacketCodex<RAW, TARGET> nodeBoolean(Function<TARGET, Boolean> getter, BiConsumer<TARGET, Boolean> setter) {
        return this.node(Boolean.class, false, getter, setter, ByteBuf::writeBoolean, ByteBuf::readBoolean);
    }

    public PacketCodex<RAW, TARGET> toggleBoolean(Function<TARGET, Boolean> getter, BiConsumer<TARGET, Boolean> setter) {
        return this.nodeBoolean(getter, (t, b) -> setter.accept(t, b == false));
    }

    public <DATA> PacketCodex<RAW, TARGET> node(Class<DATA> clazz, boolean isArray, Function<TARGET, DATA> getter, BiConsumer<TARGET, DATA> setter, BiConsumer<ByteBuf, DATA> encoder, Function<ByteBuf, DATA> decoder) {
        return this.node(new PacketCodexEntry<TARGET, DATA>(clazz, isArray, getter, setter, encoder, decoder));
    }

    public <DATA> PacketCodex<RAW, TARGET> node(Function<TARGET, DATA> getter, BiConsumer<TARGET, DATA> setter, BiConsumer<ByteBuf, DATA> encoder, Function<ByteBuf, DATA> decoder) {
        return this.node(new PacketCodexEntry<TARGET, DATA>(null, false, getter, setter, encoder, decoder));
    }

    public <DATA> PacketCodex<RAW, TARGET> node(PacketCodexEntry<TARGET, DATA> entry) {
        this.entries.add(entry);
        return this;
    }

    public List<Consumer<ByteBuf>> encodeAsWriters(TARGET target) {
        return this.getEntries().stream().map(entry -> {
            Object o = entry.getGetter().apply(target);
            BiConsumer encoder = entry.getEncoder();
            return byteBuf -> encoder.accept((ByteBuf)byteBuf, o);
        }).collect(Collectors.toList());
    }

    public List<Consumer<TARGET>> decodeAsSetters(ByteBuf byteBuf) {
        return this.getEntries().stream().map(entry -> {
            Function decoder = entry.getDecoder();
            Object data = decoder.apply(byteBuf);
            BiConsumer setter = entry.getSetter();
            return target -> setter.accept(target, data);
        }).collect(Collectors.toList());
    }

    public abstract boolean isValid(RAW var1);

    public abstract IPacket build(RAW var1);

    public void sendToServer(RAW raw) {
        try {
            ICBMClassic.packetHandler.sendToServer(this.build(raw));
        }
        catch (Exception e) {
            ICBMClassic.logger().error("Failed to send packet(" + this.parent + ", " + this.name + ") to server for " + raw, (Throwable)e);
        }
    }

    public void sendPacketToGuiUsers(RAW raw, Collection<EntityPlayer> players) {
        try {
            IPacket packet = this.build(raw);
            players.stream().filter(player -> player instanceof EntityPlayerMP).forEach(player -> ICBMClassic.packetHandler.sendToPlayer(packet, (EntityPlayerMP)player));
        }
        catch (Exception e) {
            ICBMClassic.logger().error("Failed to send packet(" + this.parent + ", " + this.name + ") to gui users for " + raw, (Throwable)e);
        }
    }

    public void sendToAllAround(RAW raw, NetworkRegistry.TargetPoint point) {
        try {
            ICBMClassic.packetHandler.sendToAllAround(this.build(raw), point);
        }
        catch (Exception e) {
            ICBMClassic.logger().error("Failed to send packet(" + this.parent + ", " + this.name + ") to server for " + raw, (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s(%s,%s,%s)", this.getClass().getName(), this.id, this.parent, this.name);
    }

    public String generateLogMessage(@Nullable World world, @Nullable BlockPos pos, @Nonnull String message) {
        return String.format(LOGGER_TEMPLATE, this.getId(), message, Optional.ofNullable(world).map(World::func_72912_H).map(WorldInfo::func_76065_j).orElse("--"), Optional.ofNullable(pos).map(Vec3i::func_177958_n).map(Object::toString).orElse("-"), Optional.ofNullable(pos).map(Vec3i::func_177956_o).map(Object::toString).orElse("-"), Optional.ofNullable(pos).map(Vec3i::func_177952_p).map(Object::toString).orElse("-"), this.getClass(), this.getParent(), this.getName());
    }

    public void logDebug(@Nullable World world, @Nullable BlockPos pos, @Nonnull String message) {
        if (ICBMClassic.logger().isDebugEnabled()) {
            ICBMClassic.logger().debug(this.generateLogMessage(world, pos, message));
        }
    }

    public void logError(@Nullable World world, @Nullable BlockPos pos, @Nonnull String message) {
        ICBMClassic.logger().error(this.generateLogMessage(world, pos, message));
    }

    public void logError(@Nullable World world, @Nullable BlockPos pos, @Nonnull String message, Exception e) {
        ICBMClassic.logger().error(this.generateLogMessage(world, pos, message), (Throwable)e);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public boolean allowServer() {
        return this.allowServer;
    }

    @Generated
    public boolean allowClient() {
        return this.allowClient;
    }

    @Generated
    public ResourceLocation getParent() {
        return this.parent;
    }

    @Generated
    public ResourceLocation getName() {
        return this.name;
    }

    @Generated
    public Function<RAW, TARGET> getConverter() {
        return this.converter;
    }

    @Generated
    public List<PacketCodexEntry<TARGET, ?>> getEntries() {
        return this.entries;
    }

    @Generated
    public TriConsumer<RAW, TARGET, EntityPlayer> onFinished() {
        return this.onFinished;
    }

    @Generated
    public PacketCodex<RAW, TARGET> allowServer(boolean allowServer) {
        this.allowServer = allowServer;
        return this;
    }

    @Generated
    public PacketCodex<RAW, TARGET> allowClient(boolean allowClient) {
        this.allowClient = allowClient;
        return this;
    }

    @Generated
    public PacketCodex<RAW, TARGET> onFinished(TriConsumer<RAW, TARGET, EntityPlayer> onFinished) {
        this.onFinished = onFinished;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketCodex)) {
            return false;
        }
        PacketCodex other = (PacketCodex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.allowServer() != other.allowServer()) {
            return false;
        }
        if (this.allowClient() != other.allowClient()) {
            return false;
        }
        ResourceLocation this$parent = this.getParent();
        ResourceLocation other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        ResourceLocation this$name = this.getName();
        ResourceLocation other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Function<RAW, TARGET> this$converter = this.getConverter();
        Function<RAW, TARGET> other$converter = other.getConverter();
        if (this$converter == null ? other$converter != null : !this$converter.equals(other$converter)) {
            return false;
        }
        List<PacketCodexEntry<TARGET, ?>> this$entries = this.getEntries();
        List<PacketCodexEntry<TARGET, ?>> other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        TriConsumer<RAW, TARGET, EntityPlayer> this$onFinished = this.onFinished();
        TriConsumer<RAW, TARGET, EntityPlayer> other$onFinished = other.onFinished();
        return !(this$onFinished == null ? other$onFinished != null : !this$onFinished.equals(other$onFinished));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PacketCodex;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + (this.allowServer() ? 79 : 97);
        result = result * 59 + (this.allowClient() ? 79 : 97);
        ResourceLocation $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        ResourceLocation $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Function<RAW, TARGET> $converter = this.getConverter();
        result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
        List<PacketCodexEntry<TARGET, ?>> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        TriConsumer<RAW, TARGET, EntityPlayer> $onFinished = this.onFinished();
        result = result * 59 + ($onFinished == null ? 43 : $onFinished.hashCode());
        return result;
    }

    @Generated
    public PacketCodex(ResourceLocation parent, ResourceLocation name, Function<RAW, TARGET> converter) {
        this.parent = parent;
        this.name = name;
        this.converter = converter;
    }

    @Generated
    void setId(int id) {
        this.id = id;
    }
}

