/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.energy.system;

import icbm.classic.ICBMClassic;
import icbm.classic.lib.energy.system.IEnergySystem;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergySystemFE
implements IEnergySystem {
    private Field energyStorageField;
    private boolean failedEnergyStorageField;

    @Override
    public boolean canSupport(Object object, EnumFacing side) {
        if (object instanceof TileEntity) {
            return ((TileEntity)object).hasCapability(CapabilityEnergy.ENERGY, side);
        }
        if (object instanceof Entity) {
            return ((Entity)object).hasCapability(CapabilityEnergy.ENERGY, side);
        }
        if (object instanceof ItemStack) {
            return ((ItemStack)object).hasCapability(CapabilityEnergy.ENERGY, side);
        }
        return false;
    }

    public IEnergyStorage getCapability(Object object, EnumFacing side) {
        if (object instanceof TileEntity) {
            return (IEnergyStorage)((TileEntity)object).getCapability(CapabilityEnergy.ENERGY, side);
        }
        if (object instanceof Entity) {
            return (IEnergyStorage)((Entity)object).getCapability(CapabilityEnergy.ENERGY, side);
        }
        if (object instanceof ItemStack) {
            return (IEnergyStorage)((ItemStack)object).getCapability(CapabilityEnergy.ENERGY, side);
        }
        return null;
    }

    @Override
    public int setEnergy(Object object, EnumFacing side, int energy, boolean simulate) {
        IEnergyStorage storage = this.getCapability(object, side);
        if (storage != null) {
            int energyLimited = Math.max(0, Math.min(storage.getMaxEnergyStored(), energy));
            if (storage instanceof EnergyStorage && !this.failedEnergyStorageField) {
                try {
                    if (this.energyStorageField == null) {
                        this.energyStorageField = EnergyStorage.class.getDeclaredField("energy");
                        this.energyStorageField.setAccessible(true);
                    }
                    this.energyStorageField.setInt(storage, energyLimited);
                }
                catch (Exception ex) {
                    this.failedEnergyStorageField = true;
                    ICBMClassic.logger().error("Failed to access EnergyStorage#energy to set energy value directly", (Throwable)ex);
                }
            }
            return this.removeEnergy(object, side, Integer.MAX_VALUE, simulate);
        }
        return 0;
    }

    @Override
    public boolean canSetEnergyDirectly(Object object, EnumFacing side) {
        return !this.failedEnergyStorageField && this.getCapability(object, side) instanceof EnergyStorage;
    }

    @Override
    public int getEnergy(Object object, EnumFacing side) {
        IEnergyStorage storage = this.getCapability(object, side);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getCapacity(Object object, EnumFacing side) {
        IEnergyStorage storage = this.getCapability(object, side);
        if (storage != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public int addEnergy(Object object, EnumFacing side, int energyToAdd, boolean simulate) {
        IEnergyStorage storage = this.getCapability(object, side);
        if (storage != null) {
            return storage.receiveEnergy(energyToAdd, simulate);
        }
        return 0;
    }

    @Override
    public int removeEnergy(Object object, EnumFacing side, int energyToRemove, boolean simulate) {
        IEnergyStorage storage = this.getCapability(object, side);
        if (storage != null) {
            return storage.extractEnergy(energyToRemove, simulate);
        }
        return 0;
    }
}

