/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.capability.missile;

import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.reg.obj.IBuildableObject;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class CapabilityMissileStack
implements ICapabilityMissileStack {
    private final ItemStack stack;

    public CapabilityMissileStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public String getMissileId() {
        return "icbmclassic:missile[" + Optional.ofNullable(ICBMClassicHelpers.getExplosive(this.stack)).map(IExplosive::getExplosiveData).map(IBuildableObject::getRegistryKey).map(Object::toString).orElse("unknown") + "]";
    }

    @Override
    public IMissile newMissile(World world) {
        EntityExplosiveMissile missile = new EntityExplosiveMissile(world);
        missile.explosive.setStack(this.stack);
        return missile.getMissileCapability();
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ICapabilityMissileStack.class, (Capability.IStorage)new Capability.IStorage<ICapabilityMissileStack>(){

            @Nullable
            public NBTBase writeNBT(Capability<ICapabilityMissileStack> capability, ICapabilityMissileStack instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<ICapabilityMissileStack> capability, ICapabilityMissileStack instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> new CapabilityMissileStack(ItemStack.field_190927_a));
    }
}

