/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.actions.status;

import com.google.common.collect.ImmutableList;
import icbm.classic.api.actions.status.ActionStatusTypes;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.data.meta.MetaTag;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ImmutableStatus
implements IActionStatus {
    private final ResourceLocation regName;
    private final ImmutableList<MetaTag> typeTags;
    protected final String translationKey;
    protected ITextComponent textComponent;

    protected ImmutableStatus(ResourceLocation regName, MetaTag ... tags) {
        this.regName = regName;
        this.typeTags = ImmutableList.copyOf((Object[])tags);
        this.translationKey = "info." + regName.toString();
    }

    public static ImmutableStatus blocking(ResourceLocation regName) {
        return new ImmutableStatus(regName, ActionStatusTypes.BLOCKING);
    }

    public static ImmutableStatus error(ResourceLocation regName) {
        return new ImmutableStatus(regName, ActionStatusTypes.BLOCKING, ActionStatusTypes.ERROR);
    }

    public static ImmutableStatus create(ResourceLocation regName, MetaTag ... tags) {
        return new ImmutableStatus(regName, tags);
    }

    @Override
    public ITextComponent message() {
        if (this.textComponent == null) {
            this.textComponent = new TextComponentTranslation(this.translationKey, new Object[0]);
        }
        return this.textComponent;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return this.regName;
    }

    public String toString() {
        return "ActionStatus[ '" + this.getRegistryKey() + "' , '" + this.translationKey + "' ]@" + this.hashCode();
    }

    @Generated
    public ImmutableList<MetaTag> getTypeTags() {
        return this.typeTags;
    }
}

