/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.actions.conditionals.timer;

import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.conditions.IConditionCause;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.content.actions.causeby.CauseByTimer;
import icbm.classic.lib.actions.conditionals.Condition;
import icbm.classic.lib.actions.conditionals.timer.TimerTickingStatus;
import icbm.classic.lib.actions.status.ActionResponses;
import icbm.classic.lib.saving.NbtSaveHandler;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class TimerCondition
extends Condition
implements IConditionCause {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "timer");
    private int target = 0;
    private int current = 0;
    private IActionStatus statusCache;
    private static final NbtSaveHandler<TimerCondition> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("tick_current", TimerCondition::getCurrent, TimerCondition::setCurrent).nodeInteger("tick_target", TimerCondition::getTarget, TimerCondition::setTarget).base();

    @Override
    public void onTick() {
        if (this.current < this.target) {
            ++this.current;
            this.statusCache = null;
        }
    }

    @Override
    public void reset() {
        this.current = 0;
    }

    @Override
    public IActionStatus getCondition() {
        if (this.current <= 0) {
            return ActionResponses.READY;
        }
        if (this.statusCache == null) {
            this.statusCache = new TimerTickingStatus(this.current, this.target);
        }
        return this.statusCache;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public IActionCause getCause() {
        return new CauseByTimer(this.getName(), this.target);
    }

    @Generated
    public TimerCondition() {
    }

    @Generated
    public TimerCondition(int target, int current, IActionStatus statusCache) {
        this.target = target;
        this.current = current;
        this.statusCache = statusCache;
    }

    @Generated
    public int getTarget() {
        return this.target;
    }

    @Generated
    public void setTarget(int target) {
        this.target = target;
    }

    @Generated
    public int getCurrent() {
        return this.current;
    }

    @Generated
    private void setCurrent(int current) {
        this.current = current;
    }
}

