/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.actions;

import icbm.classic.api.actions.IActionData;
import icbm.classic.api.actions.data.ActionField;
import icbm.classic.api.actions.data.IActionFieldProvider;
import icbm.classic.api.actions.data.IActionFieldReceiver;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class ActionDataBase
implements IActionData,
IActionFieldProvider,
IActionFieldReceiver,
INBTSerializable<NBTTagCompound> {
    private final Map<ActionField, Object> fieldValueMap = new HashMap<ActionField, Object>();

    @Override
    public <VALUE, TAG extends NBTBase> void setValue(ActionField<VALUE, TAG> key, VALUE value) {
        if (this.getFields().contains(key)) {
            this.fieldValueMap.put(key, value);
        }
    }

    @Override
    public <VALUE, TAG extends NBTBase> VALUE getValue(ActionField<VALUE, TAG> key) {
        return key.cast(this.fieldValueMap.get(key));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (!this.fieldValueMap.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<ActionField, Object> entry : this.fieldValueMap.entrySet()) {
                Object valueSave;
                NBTTagCompound entryTag = new NBTTagCompound();
                entryTag.func_74778_a("key", entry.getKey().getKey());
                if (entry.getValue() != null && (valueSave = entry.getKey().save(entry.getValue())) != null) {
                    entryTag.func_74782_a("value", valueSave);
                }
                list.func_74742_a((NBTBase)entryTag);
            }
            tag.func_74782_a("fields", (NBTBase)list);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("fields")) {
            this.fieldValueMap.clear();
            NBTTagList list = nbt.func_150295_c("fields", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound entryTag = list.func_150305_b(i);
                String key = entryTag.func_74779_i("key");
                ActionField actionField = ActionField.find(key, null);
                if (actionField == null || !entryTag.func_74764_b("value")) continue;
                this.fieldValueMap.put(actionField, actionField.load(entryTag.func_74781_a("value")));
            }
        }
    }
}

