/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.tracker;

import icbm.classic.api.events.MissileEvent;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import icbm.classic.content.missile.tracker.MissileTrackerWorld;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="icbmclassic")
public class MissileTrackerHandler {
    private static final String DATA_SAVE_ID = "icbmclassicMissileTracker";
    private static final HashMap<Integer, MissileTrackerWorld> dimToHandlerMap = new HashMap();

    public static boolean simulateMissile(EntityExplosiveMissile missile) {
        if (missile != null && !missile.field_70128_L && !missile.func_184218_aH() && MissileTrackerHandler.noPlayer(missile)) {
            MissileEvent.EnteringSimQueue event = new MissileEvent.EnteringSimQueue(missile.getMissileCapability(), missile);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            MissileTrackerHandler.getOrCreateHandler(missile.field_70170_p, true).simulateMissile(missile);
        }
        return false;
    }

    private static boolean noPlayer(EntityMissile missile) {
        return missile.func_184188_bt().stream().noneMatch(e -> e instanceof EntityPlayer);
    }

    public static MissileTrackerWorld getOrCreateHandler(World world, boolean create) {
        String trackerName = DATA_SAVE_ID + world.field_73011_w.getDimension();
        if (dimToHandlerMap.containsKey(world.field_73011_w.getDimension())) {
            return dimToHandlerMap.get(world.field_73011_w.getDimension());
        }
        if (create) {
            MissileTrackerWorld instance = (MissileTrackerWorld)world.getPerWorldStorage().func_75742_a(MissileTrackerWorld.class, trackerName);
            if (instance == null) {
                instance = new MissileTrackerWorld(trackerName);
                world.getPerWorldStorage().func_75745_a(trackerName, (WorldSavedData)instance);
            }
            dimToHandlerMap.put(world.field_73011_w.getDimension(), instance);
            return instance;
        }
        return dimToHandlerMap.getOrDefault(world.field_73011_w.getDimension(), null);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            MissileTrackerHandler.getOrCreateHandler(event.getWorld(), true);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        MissileTrackerWorld handler;
        if (!event.getWorld().field_72995_K && (handler = MissileTrackerHandler.getOrCreateHandler(event.getWorld(), false)) != null) {
            handler.destroy();
            dimToHandlerMap.remove(event.getWorld().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        MissileTrackerWorld handler;
        if (!event.world.field_72995_K && (handler = MissileTrackerHandler.getOrCreateHandler(event.world, false)) != null) {
            handler.onWorldTick(event.world);
        }
    }
}

