/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight.prefab;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.content.missile.logic.flight.prefab.FlightLogic;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public abstract class AccelerateByFacingLogic
extends FlightLogic {
    private EnumFacing direction;
    private double acceleration;
    private double velocityAdded = 0.0;
    private static final NbtSaveHandler<AccelerateByFacingLogic> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeDouble("acceleration", AccelerateByFacingLogic::getAcceleration, AccelerateByFacingLogic::setAcceleration).nodeFacing("direction", AccelerateByFacingLogic::getDirection, AccelerateByFacingLogic::setDirection).base();

    @Override
    protected void dumpInformation(Consumer<String> outputLines) {
        super.dumpInformation(outputLines);
        outputLines.accept("\tDirection: " + this.direction);
        outputLines.accept("\tAcceleration: " + this.acceleration);
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        super.onEntityTick(entity, missile, ticksInAir);
        if (this.isValid() && !this.isDone()) {
            entity.field_70159_w += (double)this.direction.func_82601_c() * this.acceleration;
            entity.field_70181_x += (double)this.direction.func_96559_d() * this.acceleration;
            entity.field_70179_y += (double)this.direction.func_82599_e() * this.acceleration;
            this.velocityAdded += this.acceleration;
        }
    }

    @Override
    public boolean isValid() {
        return this.direction != null;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public EnumFacing getDirection() {
        return this.direction;
    }

    @Generated
    public AccelerateByFacingLogic setDirection(EnumFacing direction) {
        this.direction = direction;
        return this;
    }

    @Generated
    public double getAcceleration() {
        return this.acceleration;
    }

    @Generated
    public AccelerateByFacingLogic setAcceleration(double acceleration) {
        this.acceleration = acceleration;
        return this;
    }

    @Generated
    public double getVelocityAdded() {
        return this.velocityAdded;
    }
}

