/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight.move;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.content.missile.logic.flight.prefab.AccelerateByVec3Logic;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class MoveByVec3Logic
extends AccelerateByVec3Logic {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "engine.move.vector");
    private double distance;
    private boolean relative = false;
    private static final NbtSaveHandler<MoveByVec3Logic> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeDouble("distance", MoveByVec3Logic::getDistance, MoveByVec3Logic::setDistance).base();

    @Override
    protected void dumpInformation(Consumer<String> outputLines) {
        super.dumpInformation(outputLines);
        outputLines.accept("\tDistance: " + this.distance);
        outputLines.accept("\tRelative: " + this.relative);
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        super.onEntityTick(entity, missile, ticksInAir);
        if (this.relative) {
            this.distance -= this.getVelocityAdded();
        } else {
            this.distance -= this.getDirection().field_72450_a * entity.field_70159_w;
            this.distance -= this.getDirection().field_72448_b * entity.field_70181_x;
            this.distance -= this.getDirection().field_72449_c * entity.field_70179_y;
        }
    }

    @Override
    public boolean isDone() {
        return this.distance <= 0.0;
    }

    @Override
    public boolean canSafelyExitLogic() {
        return super.canSafelyExitLogic();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public double getDistance() {
        return this.distance;
    }

    @Generated
    public MoveByVec3Logic setDistance(double distance) {
        this.distance = distance;
        return this;
    }

    @Generated
    public boolean isRelative() {
        return this.relative;
    }

    @Generated
    public MoveByVec3Logic setRelative(boolean relative) {
        this.relative = relative;
        return this;
    }
}

