/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.logic.flight.move;

import icbm.classic.api.missiles.IMissile;
import icbm.classic.content.missile.logic.flight.prefab.AccelerateByFacingLogic;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class MoveByFacingLogic
extends AccelerateByFacingLogic {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "engine.move.facing");
    private double distance;
    private boolean relative = false;
    private static final NbtSaveHandler<MoveByFacingLogic> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeDouble("distance", MoveByFacingLogic::getDistance, MoveByFacingLogic::setDistance).base();

    @Override
    protected void dumpInformation(Consumer<String> outputLines) {
        super.dumpInformation(outputLines);
        outputLines.accept("\tDistance: " + this.distance);
        outputLines.accept("\tRelative: " + this.relative);
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return REG_NAME;
    }

    @Override
    public void onEntityTick(Entity entity, IMissile missile, int ticksInAir) {
        super.onEntityTick(entity, missile, ticksInAir);
        if (this.relative) {
            this.distance -= this.getVelocityAdded();
        } else {
            this.distance -= (double)this.getDirection().func_82601_c() * entity.field_70159_w;
            this.distance -= (double)this.getDirection().func_96559_d() * entity.field_70181_x;
            this.distance -= (double)this.getDirection().func_82599_e() * entity.field_70179_y;
        }
    }

    @Override
    public boolean isDone() {
        return this.distance <= 0.0;
    }

    @Override
    public boolean canSafelyExitLogic() {
        return super.canSafelyExitLogic();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this, super.serializeNBT());
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public double getDistance() {
        return this.distance;
    }

    @Generated
    public MoveByFacingLogic setDistance(double distance) {
        this.distance = distance;
        return this;
    }

    @Generated
    public boolean isRelative() {
        return this.relative;
    }

    @Generated
    public MoveByFacingLogic setRelative(boolean relative) {
        this.relative = relative;
        return this;
    }
}

