/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity.anti;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.entity.anti.EntitySurfaceToAirMissile;
import icbm.classic.lib.buildable.BuildableObject;
import icbm.classic.lib.radar.RadarEntity;
import icbm.classic.lib.radar.RadarRegistry;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class SAMTargetData
extends BuildableObject<SAMTargetData, IBuilderRegistry<IMissileTarget>>
implements IMissileTarget {
    public static final ResourceLocation REG_NAME = new ResourceLocation("icbmclassic", "anti.missile");
    private static final int MAX_TARGETS = 5;
    private static final int SCAN_DELAY = 10;
    private final Queue<Entity> targets = new LinkedList<Entity>();
    private Entity currentTarget;
    private final EntitySurfaceToAirMissile host;
    private int scanDelayTick = 0;

    public SAMTargetData(EntitySurfaceToAirMissile host) {
        super(REG_NAME, ICBMClassicAPI.MISSILE_TARGET_DATA_REGISTRY, null);
        this.host = host;
    }

    public void tick() {
        if (this.scanDelayTick < 10) {
            ++this.scanDelayTick;
        } else if (this.targets.isEmpty()) {
            this.scanDelayTick = 0;
            this.refreshTargets();
        }
    }

    public void refreshTargets() {
        if (ConfigMissile.SAM_MISSILE.RADAR_MAP_ONLY) {
            this.seekByRadar();
        } else {
            this.seekByAABB();
        }
    }

    private void seekByRadar() {
        List<RadarEntity> entries = RadarRegistry.getRadarMapForWorld(this.host.field_70170_p).getRadarObjects(this.host.x(), this.host.y(), ConfigMissile.SAM_MISSILE.TARGET_RANGE);
        List valid = entries.stream().filter(RadarEntity::isValid).map(e -> e.entity).filter(this::isValid).collect(Collectors.toList());
        entries.sort((a, b) -> {
            double distanceA = this.host.func_70068_e(a.entity);
            double distanceB = this.host.func_70068_e(b.entity);
            return Double.compare(distanceA, distanceB);
        });
        this.targets.addAll(valid.subList(0, Math.min(5, valid.size())));
    }

    private void seekByAABB() {
        List<Entity> missiles = this.getValidTargets();
        missiles.sort((a, b) -> {
            double distanceA = this.host.func_70068_e((Entity)a);
            double distanceB = this.host.func_70068_e((Entity)b);
            return Double.compare(distanceA, distanceB);
        });
        this.targets.addAll(missiles.subList(0, Math.min(5, missiles.size())));
    }

    private List<Entity> getValidTargets() {
        return this.host.world().func_175647_a(EntityMissile.class, this.targetArea(), this::isValid);
    }

    private AxisAlignedBB targetArea() {
        return new AxisAlignedBB(this.host.x() - (double)ConfigMissile.SAM_MISSILE.TARGET_RANGE, this.host.y() - (double)ConfigMissile.SAM_MISSILE.TARGET_RANGE, this.host.z() - (double)ConfigMissile.SAM_MISSILE.TARGET_RANGE, this.host.x() + (double)ConfigMissile.SAM_MISSILE.TARGET_RANGE, this.host.y() + (double)ConfigMissile.SAM_MISSILE.TARGET_RANGE, this.host.z() + (double)ConfigMissile.SAM_MISSILE.TARGET_RANGE);
    }

    private boolean isValid(Entity entity) {
        return entity instanceof EntityMissile && !(entity instanceof EntitySurfaceToAirMissile) && entity.func_70089_S();
    }

    public Entity getTarget() {
        if (!this.isValid(this.currentTarget)) {
            this.currentTarget = null;
        }
        while (this.currentTarget == null && this.targets.peek() != null) {
            this.currentTarget = this.targets.poll();
            if (this.isValid(this.currentTarget)) continue;
            this.currentTarget = null;
        }
        return this.currentTarget;
    }

    @Override
    public Vec3d getPosition() {
        return this.getTarget() != null ? this.getTarget().func_174791_d() : null;
    }

    @Override
    public boolean isValid() {
        return this.isValid(this.getTarget());
    }

    @Override
    public double getX() {
        return Optional.ofNullable(this.getTarget()).map(entity -> entity.field_70165_t).orElse(0.0);
    }

    @Override
    public double getY() {
        return Optional.ofNullable(this.getTarget()).map(entity -> entity.field_70163_u).orElse(0.0);
    }

    @Override
    public double getZ() {
        return Optional.ofNullable(this.getTarget()).map(entity -> entity.field_70161_v).orElse(0.0);
    }

    @Generated
    public void setCurrentTarget(Entity currentTarget) {
        this.currentTarget = currentTarget;
    }
}

