/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cluster.missile;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.missiles.projectile.IProjectileStack;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.content.cargo.parachute.ParachuteProjectileData;
import icbm.classic.content.cluster.missile.CapabilityClusterMissileStack;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.projectile.ProjectileStack;
import icbm.classic.prefab.item.ItemBase;
import icbm.classic.prefab.item.ItemStackCapProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemClusterMissile
extends ItemBase {
    public ItemClusterMissile() {
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        ItemStackCapProvider provider = new ItemStackCapProvider(stack);
        provider.add("missile", ICBMClassicAPI.MISSILE_STACK_CAPABILITY, new CapabilityClusterMissileStack(stack));
        return provider;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            IProjectileStack projectileStack;
            items.add((Object)new ItemStack((Item)this));
            items.add((Object)this.createStack(new ItemStack(Items.field_151032_g), 200));
            items.add((Object)this.createStack(new ItemStack(ItemReg.itemBombletExplosive, 1, ICBMExplosives.CONDENSED.getRegistryID()), 100));
            ItemStack parachute = new ItemStack((Item)ItemReg.itemParachute);
            if (parachute.hasCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null) && (projectileStack = (IProjectileStack)parachute.getCapability(ICBMClassicAPI.PROJECTILE_STACK_CAPABILITY, null)) instanceof ProjectileStack) {
                ParachuteProjectileData projectileData = new ParachuteProjectileData();
                projectileData.setHeldItem(new ItemStack(Items.field_151106_aX));
                ((ProjectileStack)projectileStack).setProjectileData(projectileData);
            }
            items.add((Object)this.createStack(parachute, 50));
        }
    }

    private ItemStack createStack(ItemStack projectile, int count) {
        ItemStack clusterStack = new ItemStack((Item)this, 1);
        if (!clusterStack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) {
            return clusterStack;
        }
        CapabilityClusterMissileStack cap = (CapabilityClusterMissileStack)clusterStack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null);
        for (int i = 0; i < count; ++i) {
            cap.getActionDataCluster().getClusterSpawnEntries().add((Object)projectile.func_77946_l());
        }
        return clusterStack;
    }

    @Override
    protected boolean hasDetailedInfo(ItemStack stack, EntityPlayer player) {
        return true;
    }

    protected void getDetailedInfo(ItemStack stack, EntityPlayer player, List list) {
        StringBuilder contents = new StringBuilder("\n");
        CapabilityClusterMissileStack cap = (CapabilityClusterMissileStack)stack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null);
        if (cap.getActionDataCluster().getClusterSpawnEntries().isEmpty()) {
            contents.append("empty");
        } else {
            HashMap<String, Integer> contentMap = new HashMap<String, Integer>();
            for (ItemStack itemStack : cap.getActionDataCluster().getClusterSpawnEntries()) {
                int count = contentMap.computeIfAbsent(itemStack.func_82833_r(), k -> 0);
                contentMap.put(itemStack.func_82833_r(), count + 1);
            }
            for (Map.Entry entry : contentMap.entrySet()) {
                contents.append("\t").append(entry.getValue()).append(" x ").append((String)entry.getKey());
            }
        }
        TextComponentTranslation translation = new TextComponentTranslation(this.func_77658_a() + ".contents", new Object[]{contents.toString()});
        LanguageUtility.outputLines((ITextComponent)translation, list::add);
    }
}

