/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cluster.missile;

import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.actions.conditionals.ConditionAnd;
import icbm.classic.content.actions.conditionals.ConditionTargetDistance;
import icbm.classic.content.actions.conditionals.ConditionalImpact;
import icbm.classic.content.cluster.action.ActionDataCluster;
import icbm.classic.content.missile.entity.explosive.EntityMissileActionable;
import icbm.classic.lib.saving.NbtSaveHandler;
import lombok.Generated;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityClusterMissileStack
implements ICapabilityMissileStack,
INBTSerializable<NBTTagCompound> {
    private final ItemStack stack;
    private final ActionDataCluster actionDataCluster = new ActionDataCluster();
    private static final NbtSaveHandler<CapabilityClusterMissileStack> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeINBTSerializable("cluster_action", CapabilityClusterMissileStack::getActionDataCluster).base();

    public CapabilityClusterMissileStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public String getMissileId() {
        return "icbmclassic:missile[cluster]";
    }

    @Override
    public IMissile newMissile(World world) {
        EntityMissileActionable missile = (EntityMissileActionable)new EntityMissileActionable(world).setOriginalStack(this.stack).setActionData(this.actionDataCluster).initHealth(ConfigMissile.CLUSTER_MISSILE.MAX_HEALTH);
        ConditionAnd conditionAnd = new ConditionAnd();
        conditionAnd.getConditions().add(new ConditionalImpact().setImpactDesired(false));
        conditionAnd.getConditions().add(new ConditionTargetDistance().setTriggerDistance(3.0));
        missile.getMainAction().withCondition(conditionAnd);
        return missile.getMissileCapability();
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public ActionDataCluster getActionDataCluster() {
        return this.actionDataCluster;
    }
}

