/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cluster.bomblet;

import com.google.common.collect.ImmutableList;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.data.meta.MetaTag;
import icbm.classic.api.missiles.projectile.IProjectileData;
import icbm.classic.api.missiles.projectile.IProjectileDataRegistry;
import icbm.classic.api.missiles.projectile.ProjectileTypes;
import icbm.classic.content.cluster.bomblet.EntityBombDroplet;
import java.util.Collection;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public class BombletProjectileData
implements IProjectileData<EntityBombDroplet>,
INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation NAME = new ResourceLocation("icbmclassic", "bomblet");
    public static final ImmutableList<MetaTag> TYPES = ImmutableList.of((Object)ProjectileTypes.TYPE_EXPLOSIVE);
    private ItemStack explosiveStack = ItemStack.field_190927_a;

    @Override
    @Nonnull
    public Collection<MetaTag> getTypeTags() {
        return TYPES;
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return NAME;
    }

    @Override
    @Nonnull
    public IProjectileDataRegistry getRegistry() {
        return ICBMClassicAPI.PROJECTILE_DATA_REGISTRY;
    }

    @Override
    public EntityBombDroplet newEntity(World world, boolean allowItemPickup) {
        EntityBombDroplet bombDroplet = new EntityBombDroplet(world);
        bombDroplet.explosive.setStack(this.explosiveStack);
        return bombDroplet;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound save = new NBTTagCompound();
        save.func_74782_a("explosive", (NBTBase)this.explosiveStack.serializeNBT());
        return save;
    }

    public void deserializeNBT(NBTTagCompound save) {
        this.explosiveStack = new ItemStack(save.func_74775_l("explosive"));
    }

    @Generated
    public BombletProjectileData() {
    }

    @Generated
    public BombletProjectileData setExplosiveStack(ItemStack explosiveStack) {
        this.explosiveStack = explosiveStack;
        return this;
    }

    @Generated
    public ItemStack getExplosiveStack() {
        return this.explosiveStack;
    }
}

