/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cargo.balloon;

import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.data.LazyBuilder;
import icbm.classic.lib.projectile.EntityProjectile;
import icbm.classic.lib.saving.NbtSaveHandler;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityBalloon
extends EntityProjectile<EntityBalloon>
implements IEntityAdditionalSpawnData {
    private static final Supplier<ItemStack> DEFAULT_RENDER = new LazyBuilder<ItemStack>(() -> new ItemStack((Item)ItemReg.itemBalloon, 1, 1));
    public static final float GRAVITY = 0.005f;
    public static final float AIR_RESISTANCE = 0.9f;
    public static final float FLOATING_GRAVITY = -0.02f;
    public static final int FLOATING_DURATION = 600;
    public static final float BREAK_CHANCE = 0.05f;
    private int liftTicks = 600;
    @Nonnull
    private ItemStack renderItemStack = DEFAULT_RENDER.get();
    private static final NbtSaveHandler<EntityBalloon> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeInteger("lift_ticks", EntityBalloon::getLiftTicks, EntityBalloon::setLiftTicks).nodeItemStack("render_stack", EntityBalloon::getRenderItemStack, EntityBalloon::setRenderItemStack).base();

    public EntityBalloon(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70156_m = true;
        this.field_70158_ak = true;
    }

    @Override
    protected float getImpactDamage(Entity entityHit, float velocity, RayTraceResult hit) {
        return 0.0f;
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.liftTicks);
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.renderItemStack);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        this.liftTicks = data.readInt();
        this.renderItemStack = ByteBufUtils.readItemStack((ByteBuf)data);
    }

    @Override
    protected boolean shouldExpire() {
        return super.shouldExpire() || this.func_184188_bt().isEmpty();
    }

    public double func_70042_X() {
        return -0.25;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            if (passenger instanceof EntityItem) {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u - 0.65, this.field_70161_v);
            } else {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u + (double)passenger.field_70131_O - 0.55, this.field_70161_v);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isServer() && this.liftTicks <= 0 && this.field_70170_p.field_73012_v.nextFloat() <= 0.05f) {
            this.releaseCargoAndDespawn();
        }
    }

    @Override
    protected void decreaseMotion() {
        super.decreaseMotion();
        if (this.liftTicks > 0) {
            --this.liftTicks;
        }
    }

    @Override
    protected float getGravity() {
        if (this.liftTicks > 0) {
            return -0.02f;
        }
        return 0.005f;
    }

    @Override
    protected float getAirResistance() {
        return 0.9f;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    protected boolean ignoreImpact(RayTraceResult hit) {
        return hit.field_72308_g != null;
    }

    @Override
    protected boolean shouldCollideWith(Entity entity) {
        return super.shouldCollideWith(entity) && entity != this.shootingEntity;
    }

    @Override
    protected void onImpact(RayTraceResult hit) {
        this.releaseCargoAndDespawn();
    }

    @Override
    protected void destroy() {
        this.releaseCargoAndDespawn();
    }

    protected void releaseCargoAndDespawn() {
        if (!this.func_184188_bt().isEmpty()) {
            this.func_184226_ay();
        }
        this.func_70106_y();
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        SAVE_LOGIC.load(this, tag);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        SAVE_LOGIC.save(this, tag);
    }

    @Generated
    public int getLiftTicks() {
        return this.liftTicks;
    }

    @Generated
    public EntityBalloon setLiftTicks(int liftTicks) {
        this.liftTicks = liftTicks;
        return this;
    }

    @Generated
    public EntityBalloon setRenderItemStack(@Nonnull ItemStack renderItemStack) {
        if (renderItemStack == null) {
            throw new NullPointerException("renderItemStack is marked non-null but is null");
        }
        this.renderItemStack = renderItemStack;
        return this;
    }

    @Nonnull
    @Generated
    public ItemStack getRenderItemStack() {
        return this.renderItemStack;
    }
}

