/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.cargo;

import com.google.common.collect.ImmutableList;
import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.data.EntityActionTypes;
import icbm.classic.api.data.meta.MetaTag;
import icbm.classic.api.missiles.projectile.IProjectileData;
import icbm.classic.api.missiles.projectile.IProjectileDataRegistry;
import icbm.classic.api.missiles.projectile.ProjectileTypes;
import icbm.classic.api.reg.obj.IBuildableObject;
import icbm.classic.content.cargo.ProjectileCargoMode;
import icbm.classic.content.entity.flyingblock.BlockCaptureData;
import icbm.classic.content.entity.flyingblock.FlyingBlock;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class CargoProjectileData<T extends IBuildableObject, ENTITY extends Entity>
implements IBuildableObject,
IProjectileData<ENTITY>,
INBTSerializable<NBTTagCompound> {
    private static final ImmutableList<MetaTag> TYPE = ImmutableList.of((Object)EntityActionTypes.ENTITY_CREATION, (Object)ProjectileTypes.TYPE_HOLDER, (Object)ProjectileTypes.TYPE_THROWABLE);
    private ItemStack heldItem = ItemStack.field_190927_a;
    private ProjectileCargoMode parachuteMode = ProjectileCargoMode.ITEM;
    private static final NbtSaveHandler<CargoProjectileData> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeItemStack("stack", CargoProjectileData::getHeldItem, CargoProjectileData::setHeldItem).nodeEnumString("mode", CargoProjectileData::getParachuteMode, CargoProjectileData::setParachuteMode, ProjectileCargoMode::valueOf).base();

    @Override
    @Nonnull
    public IProjectileDataRegistry getRegistry() {
        return ICBMClassicAPI.PROJECTILE_DATA_REGISTRY;
    }

    @Override
    @Nonnull
    public Collection<MetaTag> getTypeTags() {
        return TYPE;
    }

    @Override
    public ITextComponent getTooltip() {
        return new TextComponentTranslation(this.getTranslationKey() + ".info." + this.parachuteMode.name().toLowerCase(), new Object[]{this.heldItem.func_77973_b().func_77653_i(this.heldItem)});
    }

    @Override
    public void onEntitySpawned(@Nonnull ENTITY entity, @Nullable Entity source, @Nullable EnumHand hand) {
        if (!this.heldItem.func_190926_b()) {
            switch (this.parachuteMode) {
                case PROJECTILE: {
                    this.spawnProjectile(entity);
                    return;
                }
                case ENTITY: {
                    this.spawnEntity(entity);
                    return;
                }
                case BLOCK: {
                    this.spawnBlockEntity(entity, source, hand);
                    return;
                }
            }
            this.spawnItemEntity(entity);
            return;
        }
    }

    private void spawnProjectile(@Nonnull ENTITY entity) {
        Entity projectile = ICBMClassicAPI.PROJECTILE_DATA_REGISTRY.spawnProjectile(this.heldItem, ((Entity)entity).field_70170_p, ((Entity)entity).field_70165_t, ((Entity)entity).field_70163_u, ((Entity)entity).field_70161_v, (Entity)entity, true, proj -> {
            proj.field_70125_A = proj.field_70127_C = entity.field_70125_A;
            proj.field_70177_z = proj.field_70126_B = entity.field_70177_z;
        });
        if (projectile != null) {
            projectile.func_184220_m(entity);
        } else {
            this.spawnItemEntity(entity);
        }
    }

    private void spawnEntity(@Nonnull ENTITY entity) {
        if (((Entity)entity).field_70170_p.field_72995_K) {
            return;
        }
        if (this.heldItem.func_77973_b() instanceof ItemMonsterPlacer) {
            Entity mob = ItemMonsterPlacer.func_77840_a((World)((Entity)entity).field_70170_p, (ResourceLocation)ItemMonsterPlacer.func_190908_h((ItemStack)this.heldItem), (double)((Entity)entity).field_70165_t, (double)((Entity)entity).field_70163_u, (double)((Entity)entity).field_70161_v);
            if (mob != null) {
                mob.func_184220_m(entity);
                if (mob instanceof EntityLivingBase && this.heldItem.func_82837_s()) {
                    entity.func_96094_a(this.heldItem.func_82833_r());
                }
                ItemMonsterPlacer.func_185079_a((World)((Entity)entity).field_70170_p, null, (ItemStack)this.heldItem, (Entity)mob);
            } else {
                ICBMClassic.logger().warn("ParachuteProjectile: unknown item for entity spawning. Data: {}, Item: {}", (Object)this, (Object)this.heldItem);
                this.spawnItemEntity(entity);
            }
        } else {
            ICBMClassic.logger().warn("ParachuteProjectile: unknown item for entity spawning. Data: {}, Item: {}", (Object)this, (Object)this.heldItem);
            this.spawnItemEntity(entity);
        }
    }

    private void spawnItemEntity(@Nonnull ENTITY entity) {
        EntityItem entityItem = this.createItemEntity(entity);
        if (!((Entity)entity).field_70170_p.func_72838_d((Entity)entityItem)) {
            ICBMClassic.logger().error("CargoProjectileData: Failed to spawn held item as {}, this likely resulted in loss of items", (Object)entityItem);
        }
        if (!entityItem.func_184220_m(entity)) {
            ICBMClassic.logger().error("CargoProjectileData: Failed to set {} as rider of {}, this likely resulted in loss of items", (Object)entityItem, entity);
        }
    }

    private EntityItem createItemEntity(@Nonnull ENTITY entity) {
        EntityItem entityItem = new EntityItem(((Entity)entity).field_70170_p);
        entityItem.func_92058_a(this.heldItem.func_77946_l());
        entityItem.func_70107_b(((Entity)entity).field_70165_t, ((Entity)entity).field_70163_u, ((Entity)entity).field_70161_v);
        entityItem.func_174869_p();
        return entityItem;
    }

    private void spawnBlockEntity(@Nonnull ENTITY entity, Entity source, EnumHand hand) {
        if (!(this.heldItem.func_77973_b() instanceof ItemBlock)) {
            this.spawnItemEntity(entity);
            return;
        }
        int i = this.heldItem.func_77973_b().func_77647_b(this.heldItem.func_77960_j());
        IBlockState iblockstate = null;
        try {
            EntityLivingBase entityLivingBase = source instanceof EntityLivingBase ? (EntityLivingBase)source : FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)((Entity)entity).field_70170_p));
            iblockstate = ((ItemBlock)this.heldItem.func_77973_b()).func_179223_d().getStateForPlacement(((Entity)entity).field_70170_p, entity.func_180425_c(), EnumFacing.NORTH, 0.5f, 1.0f, 0.5f, i, entityLivingBase, hand);
        }
        catch (Exception e) {
            ICBMClassic.logger().error("CargoProjectileData: Failed to use Block#getStateForPlacement to get block state. This may cause incorrect block placements", (Throwable)e);
            iblockstate = ((ItemBlock)this.heldItem.func_77973_b()).func_179223_d().func_176203_a(i);
        }
        BlockCaptureData blockCaptureData = new BlockCaptureData(iblockstate, this.heldItem.func_77946_l());
        if (!FlyingBlock.spawnFlyingBlock(((Entity)entity).field_70170_p, ((Entity)entity).field_70165_t, ((Entity)entity).field_70163_u, ((Entity)entity).field_70161_v, blockCaptureData, flyingBlock -> flyingBlock.func_184220_m(entity), null, null)) {
            this.spawnItemEntity(entity);
        }
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    @Generated
    public CargoProjectileData<T, ENTITY> setHeldItem(ItemStack heldItem) {
        this.heldItem = heldItem;
        return this;
    }

    @Generated
    public ProjectileCargoMode getParachuteMode() {
        return this.parachuteMode;
    }

    @Generated
    public CargoProjectileData<T, ENTITY> setParachuteMode(ProjectileCargoMode parachuteMode) {
        this.parachuteMode = parachuteMode;
        return this;
    }
}

