/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.screen;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.cause.IActionCause;
import icbm.classic.api.actions.status.IActionStatus;
import icbm.classic.api.events.LauncherSetTargetEvent;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.config.ConfigMain;
import icbm.classic.config.machines.ConfigLauncher;
import icbm.classic.content.blocks.launcher.LauncherLangs;
import icbm.classic.content.blocks.launcher.LauncherSolution;
import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.launcher.network.LauncherEntry;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import icbm.classic.content.blocks.launcher.screen.BlockScreenCause;
import icbm.classic.content.blocks.launcher.screen.LauncherPair;
import icbm.classic.content.blocks.launcher.screen.RadioScreen;
import icbm.classic.content.blocks.launcher.screen.gui.ContainerLaunchScreen;
import icbm.classic.content.blocks.launcher.screen.gui.GuiLauncherScreen;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import icbm.classic.lib.data.IMachineInfo;
import icbm.classic.lib.energy.storage.EnergyBuffer;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.network.lambda.PacketCodexReg;
import icbm.classic.lib.network.lambda.tile.PacketCodexTile;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.radio.imp.Radio;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.tile.TickAction;
import icbm.classic.prefab.gui.IPlayerUsing;
import icbm.classic.prefab.inventory.InventorySlot;
import icbm.classic.prefab.inventory.InventoryWithSlots;
import icbm.classic.prefab.tile.IGuiTile;
import icbm.classic.prefab.tile.TileMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileLauncherScreen
extends TileMachine
implements ILauncherComponent,
IMachineInfo,
IPlayerUsing,
IGuiTile {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("icbmclassic", "launcherscreen");
    private Vec3d _targetPos = Vec3d.field_186680_a;
    public final EnergyBuffer energyStorage = new EnergyBuffer(() -> ConfigLauncher.POWER_CAPACITY).withOnChange((p, c, s) -> this.func_70296_d());
    public final InventoryWithSlots inventory = new InventoryWithSlots(1).withChangeCallback((s, i) -> this.func_70296_d()).withSlot(new InventorySlot(0, EnergySystem::isEnergyItem).withTick(this.energyStorage::dischargeItem));
    private final LauncherNode launcherNode = new LauncherNode(this, false);
    public final RadioScreen radioCap = new RadioScreen(this);
    private float launcherInaccuracy = 0.0f;
    private final List<LauncherPair> statusList = new ArrayList<LauncherPair>();
    private boolean refreshStatus = false;
    private final List<EntityPlayer> playersUsing = new LinkedList<EntityPlayer>();
    public static final PacketCodexTile<TileLauncherScreen, TileLauncherScreen> PACKET_GUI = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "description").fromServer().nodeVec3d(TileLauncherScreen::getTarget, TileLauncherScreen::setTarget).nodeString(t -> t.radioCap.getChannel(), (t, f) -> t.radioCap.setChannel((String)f)).nodeBoolean(t -> t.radioCap.isDisabled(), (t, f) -> t.radioCap.setDisabled((boolean)f)).nodeFloat(t -> Float.valueOf(t.launcherInaccuracy), (t, f) -> {
        t.launcherInaccuracy = f.floatValue();
    }).nodeVec3d(TileLauncherScreen::getTarget, TileLauncherScreen::setTarget).nodeNbtCompound(t -> {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        t.statusList.forEach(pair -> {
            NBTTagCompound save = new NBTTagCompound();
            save.func_74768_a("g", pair.getGroup().intValue());
            save.func_74768_a("i", pair.getIndex().intValue());
            save.func_74782_a("p", (NBTBase)ICBMClassicAPI.ACTION_STATUS_REGISTRY.save(pair.getStatus()));
            list.func_74742_a((NBTBase)save);
        });
        tag.func_74782_a("p", (NBTBase)list);
        return tag;
    }, (t, tag) -> {
        NBTTagList list = tag.func_150295_c("p", 10);
        ArrayList<LauncherPair> status = new ArrayList<LauncherPair>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound save = (NBTTagCompound)list.func_179238_g(i);
            int group = save.func_74762_e("g");
            int index = save.func_74762_e("i");
            NBTTagCompound partSave = save.func_74775_l("p");
            IActionStatus part = ICBMClassicAPI.ACTION_STATUS_REGISTRY.load(partSave);
            if (part == null) continue;
            status.add(new LauncherPair(group, index, part));
        }
        t.statusList.clear();
        t.statusList.addAll(status);
    });
    public static final PacketCodexTile<TileLauncherScreen, RadioScreen> PACKET_RADIO_HZ = (PacketCodexTile)new PacketCodexTile<TileLauncherScreen, RadioScreen>(REGISTRY_NAME, "radio.frequency", t -> t.radioCap).fromClient().nodeString(Radio::getChannel, Radio::setChannel).onFinished((r, t, p) -> r.func_70296_d());
    public static final PacketCodexTile<TileLauncherScreen, RadioScreen> PACKET_RADIO_DISABLE = (PacketCodexTile)new PacketCodexTile<TileLauncherScreen, RadioScreen>(REGISTRY_NAME, "radio.disable", t -> t.radioCap).fromClient().toggleBoolean(Radio::isDisabled, Radio::setDisabled).onFinished((r, t, p) -> r.func_70296_d());
    public static final PacketCodexTile<TileLauncherScreen, TileLauncherScreen> PACKET_TARGET = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "target").fromClient().nodeVec3d(TileLauncherScreen::getTarget, TileLauncherScreen::setTarget).onFinished((r, t, p) -> r.func_70296_d());
    public static final PacketCodexTile<TileLauncherScreen, TileLauncherScreen> PACKET_LAUNCH = (PacketCodexTile)new PacketCodexTile(REGISTRY_NAME, "launch").fromClient().onFinished((r, t, p) -> {
        r.fireAllLaunchers(false);
        r.func_70296_d();
    });
    private static final NbtSaveHandler<TileLauncherScreen> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeINBTSerializable("radio", launcher -> launcher.radioCap).nodeINBTSerializable("inventory", launcher -> launcher.inventory).nodeVec3d("target", launcher -> launcher._targetPos, (launcher, pos) -> {
        launcher._targetPos = pos;
    }).base();

    public TileLauncherScreen() {
        this.tickActions.add(new TickAction(3, true, t -> PACKET_GUI.sendPacketToGuiUsers(this, this.playersUsing)));
        this.tickActions.add(new TickAction(20, true, t -> this.playersUsing.removeIf(player -> !(player.field_71070_bA instanceof ContainerLaunchScreen))));
        this.tickActions.add(this.inventory);
    }

    @Override
    public void provideInformation(BiConsumer<String, Object> consumer) {
        consumer.accept("NEEDS_POWER", ConfigMain.REQUIRES_POWER);
    }

    @Override
    public LauncherNode getNetworkNode() {
        return this.launcherNode;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer()) {
            if (this.ticks % 5 == 0 || this.refreshStatus) {
                this.refreshStatus = false;
                this.statusList.clear();
                List<LauncherEntry> launchers = this.getLaunchersInGroup();
                if (!launchers.isEmpty()) {
                    int launcherCount = launchers.size();
                    this.launcherInaccuracy = launchers.stream().map(LauncherEntry::getLauncher).map(l -> {
                        IActionStatus status = this.preCheck((IMissileLauncher)l);
                        this.statusList.add(new LauncherPair(l.getLauncherGroup(), l.getLaunchIndex(), status));
                        return Float.valueOf(l.getInaccuracy(this.getTarget(), launcherCount));
                    }).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
                }
            }
            if (this.ticks % 3 == 0 && this.field_145850_b.func_175676_y(this.func_174877_v()) > 0) {
                this.fireAllLaunchers(false);
            }
        }
    }

    @Nonnull
    public List<LauncherEntry> getLaunchersInGroup() {
        if (this.getNetworkNode().getNetwork() != null) {
            return this.getNetworkNode().getNetwork().getLaunchers(this.getFiringGroup());
        }
        return Collections.EMPTY_LIST;
    }

    public int getFiringGroup() {
        return -1;
    }

    public static void register() {
        GameRegistry.registerTileEntity(TileLauncherScreen.class, (ResourceLocation)REGISTRY_NAME);
        PacketCodexReg.register(PACKET_RADIO_HZ, PACKET_RADIO_DISABLE, PACKET_TARGET, PACKET_GUI, PACKET_LAUNCH);
    }

    public IActionStatus preCheck(IMissileLauncher launcher) {
        return launcher.preCheckLaunch(new BasicTargetData(this.getTarget()), this.createCause());
    }

    private IActionCause createCause() {
        return new BlockScreenCause(this.field_145850_b, this.field_174879_c, this.getBlockState());
    }

    public boolean fireAllLaunchers(boolean simulate) {
        this.refreshStatus = true;
        if (this.getNetworkNode().getNetwork() == null) {
            return false;
        }
        List<LauncherEntry> launchers = this.getLaunchersInGroup();
        IActionCause cause = this.createCause();
        BasicTargetData target = new BasicTargetData(this.getTarget());
        LauncherSolution solution = new LauncherSolution(target, this.getFiringGroup(), launchers.size());
        return this.getNetworkNode().getNetwork().launch(solution, cause, simulate).filter(entry -> !entry.getLastFiringStatus().isBlocking()).count() > 0L;
    }

    public boolean canLaunch() {
        return !this.statusList.isEmpty() && this.statusList.stream().map(LauncherPair::getStatus).noneMatch(IActionStatus::isBlocking);
    }

    public ITextComponent getStatusTranslation() {
        if (this.getNetworkNode().getNetwork() == null) {
            return LauncherLangs.TRANSLATION_ERROR_NO_NETWORK;
        }
        if (this.getLaunchersInGroup().isEmpty()) {
            return LauncherLangs.TRANSLATION_ERROR_NO_LAUNCHER;
        }
        if (this.statusList.isEmpty()) {
            return LauncherLangs.TRANSLATION_ERROR_NO_NETWORK_STATUS;
        }
        List errors = this.statusList.stream().filter(pair -> pair.getStatus().isBlocking()).collect(Collectors.toList());
        if (errors.isEmpty()) {
            return LauncherLangs.TRANSLATION_READY;
        }
        TextComponentTranslation status = new TextComponentTranslation("info.icbmclassic:launcher.error.missile.multi", new Object[]{errors.size(), this.statusList.size()});
        for (int i = 0; i < errors.size() && i < 5; ++i) {
            status.func_150258_a(" \n \t ");
            status.func_150257_a(((LauncherPair)errors.get(i)).getStatus().message());
        }
        return status;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerLaunchScreen(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiLauncherScreen(player, this);
    }

    public void onLoad() {
        super.onLoad();
        this.getNetworkNode().connectToTiles();
        if (this.isServer()) {
            RadioRegistry.add(this.radioCap);
        }
    }

    public void func_145843_s() {
        if (this.isServer()) {
            RadioRegistry.remove(this.radioCap);
        }
        this.getNetworkNode().onTileRemoved();
        super.func_145843_s();
    }

    public Vec3d getTarget() {
        return this._targetPos;
    }

    public void setTarget(Vec3d target) {
        if (target != this._targetPos) {
            if (this.isServer()) {
                LauncherSetTargetEvent event = new LauncherSetTargetEvent(this.field_145850_b, this.func_174877_v(), target);
                if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                    this._targetPos = event.target == null ? Vec3d.field_186680_a : event.target;
                    this.func_70296_d();
                }
            } else {
                this._targetPos = target;
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == ICBMClassicAPI.RADIO_CAPABILITY || Optional.ofNullable(this.getNetworkNode().getNetwork()).map(network -> network.hasCapability(capability, facing)).orElse(false) != false;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T cap;
        if (capability == ICBMClassicAPI.RADIO_CAPABILITY) {
            return (T)this.radioCap;
        }
        if (this.getNetworkNode().getNetwork() != null && (cap = this.getNetworkNode().getNetwork().getCapability(capability, facing)) != null) {
            return cap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        SAVE_LOGIC.load(this, nbt);
        if (nbt.func_74764_b("frequency")) {
            this.radioCap.setChannel(Integer.toString(nbt.func_74762_e("frequency")));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
        return super.func_189515_b(nbt);
    }

    @Generated
    public float getLauncherInaccuracy() {
        return this.launcherInaccuracy;
    }

    @Generated
    public List<EntityPlayer> getPlayersUsing() {
        return this.playersUsing;
    }
}

