/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.gas;

import icbm.classic.ICBMClassic;
import icbm.classic.config.ConfigMain;
import icbm.classic.content.blast.BlastMutation;
import icbm.classic.content.blast.gas.BlastGasBase;
import lombok.Generated;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3i;

public class BlastContagious
extends BlastGasBase {
    public static final DamageSource CONTAGIOUS_DAMAGE = new DamageSource("icbm.contagious");
    public static final float red = 0.3f;
    public static final float green = 0.8f;
    public static final float blue = 0.0f;
    private int toxicityBuildup = 10;
    private float toxicityScale = 0.05f;
    private float toxicityMinDamage = 1.0f;

    @Override
    protected boolean canEffectEntities() {
        return true;
    }

    @Override
    protected boolean canGasEffect(EntityLivingBase entity) {
        return super.canGasEffect(entity) && !entity.func_180431_b(CONTAGIOUS_DAMAGE);
    }

    @Override
    protected float minGasProtection() {
        return ConfigMain.protectiveArmor.minProtectionViralGas;
    }

    @Override
    protected void applyEffect(EntityLivingBase entity, int hitCount) {
        ICBMClassic.contagiousPotion.poisonEntity(this.location.toPos(), entity, 3);
        if (!BlastMutation.applyMutationEffect(entity) && hitCount > this.toxicityBuildup) {
            entity.func_70097_a(CONTAGIOUS_DAMAGE, Math.max(this.toxicityMinDamage, (float)hitCount * this.toxicityScale));
        }
    }

    @Override
    protected float getParticleColorRed(Vec3i pos) {
        return 0.3f;
    }

    @Override
    protected float getParticleColorGreen(Vec3i pos) {
        return 0.8f;
    }

    @Override
    protected float getParticleColorBlue(Vec3i pos) {
        return 0.0f;
    }

    @Generated
    public BlastContagious setToxicityBuildup(int toxicityBuildup) {
        this.toxicityBuildup = toxicityBuildup;
        return this;
    }

    @Generated
    public BlastContagious setToxicityScale(float toxicityScale) {
        this.toxicityScale = toxicityScale;
        return this;
    }

    @Generated
    public BlastContagious setToxicityMinDamage(float toxicityMinDamage) {
        this.toxicityMinDamage = toxicityMinDamage;
        return this;
    }
}

