/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.gas;

import icbm.classic.content.blast.gas.BlastGasBase;
import icbm.classic.lib.colors.ColorB;
import icbm.classic.lib.colors.ColorHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.Vec3i;

public class BlastColor
extends BlastGasBase {
    public static final int DURATION = 600;
    public static final int COLOR_COUNT = 100;
    public static final List<ColorB> PARTICLE_COLORS = new ArrayList<ColorB>(100);
    private static boolean hasSetupColors = false;
    private int currentColorIndex = 0;

    public BlastColor() {
        this.setDuration(600);
    }

    @Override
    protected boolean setupBlast() {
        if (!hasSetupColors) {
            this.generateRandomColors();
            hasSetupColors = true;
        }
        return true;
    }

    @Override
    protected boolean canEffectEntities() {
        return false;
    }

    private void generateRandomColors() {
        for (int i = 0; i < 100; ++i) {
            float hue = this.field_77287_j.field_73012_v.nextFloat();
            float saturation = 0.9f;
            float luminance = 0.5f;
            PARTICLE_COLORS.add(ColorHelper.HSBtoRGB(hue, 0.9f, 0.5f));
        }
    }

    @Override
    protected void spawnGasParticles(Vec3i pos) {
        super.spawnGasParticles(pos);
        this.currentColorIndex = (this.currentColorIndex + 1) % 100;
    }

    @Override
    protected float getParticleColorRed(Vec3i pos) {
        if (this.currentColorIndex >= 0 && this.currentColorIndex < PARTICLE_COLORS.size()) {
            return PARTICLE_COLORS.get(this.currentColorIndex).getRed();
        }
        return 1.0f;
    }

    @Override
    protected float getParticleColorGreen(Vec3i pos) {
        if (this.currentColorIndex >= 0 && this.currentColorIndex < PARTICLE_COLORS.size()) {
            return PARTICLE_COLORS.get(this.currentColorIndex).getGreen();
        }
        return 1.0f;
    }

    @Override
    protected float getParticleColorBlue(Vec3i pos) {
        if (this.currentColorIndex >= 0 && this.currentColorIndex < PARTICLE_COLORS.size()) {
            return PARTICLE_COLORS.get(this.currentColorIndex).getBlue();
        }
        return 1.0f;
    }
}

