/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.ender;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.reg.IExplosiveCustomization;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.api.reg.obj.IBuilderRegistry;
import icbm.classic.content.blast.ender.BlastEnder;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.lib.saving.NbtSaveHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;

public class EnderBlastCustomization
implements IExplosiveCustomization,
INBTSerializable<NBTTagCompound> {
    public static final ResourceLocation NAME = new ResourceLocation("icbmclassic", "ender");
    private Integer dim;
    private Vec3d pos;
    private String posTooltip;
    private String dimTooltip;
    private static final NbtSaveHandler<EnderBlastCustomization> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeVec3d("pos", EnderBlastCustomization::getPos, EnderBlastCustomization::setPos).nodeInteger("dim", EnderBlastCustomization::getDim, EnderBlastCustomization::setDim).base();

    public EnderBlastCustomization(Integer dim, Vec3d pos) {
        this.dim = dim;
        this.pos = pos;
    }

    public void setPos(Vec3d pos) {
        if (!Objects.equals(pos, this.pos)) {
            this.posTooltip = null;
        }
        this.pos = pos;
    }

    public void setDim(Integer dim) {
        if (!Objects.equals(dim, this.dim)) {
            this.dimTooltip = null;
        }
        this.dim = dim;
    }

    @Override
    public void collectCustomizationInformation(Consumer<String> collector) {
        if (this.pos != null) {
            if (this.posTooltip == null) {
                this.posTooltip = LanguageUtility.buildToolTipString((ITextComponent)new TextComponentTranslation("explosive.icbmclassic:ender.pos", new Object[]{this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c}));
            }
            collector.accept(this.posTooltip);
        }
        if (this.dim != null) {
            if (this.dimTooltip == null) {
                String worldName = Optional.ofNullable(DimensionManager.getWorld((int)this.dim)).map(World::func_72912_H).map(WorldInfo::func_76065_j).orElse("???");
                this.dimTooltip = LanguageUtility.buildToolTipString((ITextComponent)new TextComponentTranslation("explosive.icbmclassic:ender.world", new Object[]{this.dim, worldName}));
            }
            collector.accept(this.dimTooltip);
        }
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryKey() {
        return NAME;
    }

    @Override
    @Nonnull
    public IBuilderRegistry<IExplosiveCustomization> getRegistry() {
        return ICBMClassicAPI.EXPLOSIVE_CUSTOMIZATION_REGISTRY;
    }

    @Override
    public void apply(IExplosiveData explosiveData, IBlast blast) {
        if (blast instanceof BlastEnder) {
            ((BlastEnder)blast).setTeleportTarget(this.pos);
        }
    }

    public NBTTagCompound serializeNBT() {
        return SAVE_LOGIC.save(this);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        SAVE_LOGIC.load(this, nbt);
    }

    @Generated
    public Integer getDim() {
        return this.dim;
    }

    @Generated
    public Vec3d getPos() {
        return this.pos;
    }

    @Generated
    public String getPosTooltip() {
        return this.posTooltip;
    }

    @Generated
    public String getDimTooltip() {
        return this.dimTooltip;
    }

    @Generated
    public void setPosTooltip(String posTooltip) {
        this.posTooltip = posTooltip;
    }

    @Generated
    public void setDimTooltip(String dimTooltip) {
        this.dimTooltip = dimTooltip;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnderBlastCustomization)) {
            return false;
        }
        EnderBlastCustomization other = (EnderBlastCustomization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$dim = this.getDim();
        Integer other$dim = other.getDim();
        if (this$dim == null ? other$dim != null : !((Object)this$dim).equals(other$dim)) {
            return false;
        }
        Vec3d this$pos = this.getPos();
        Vec3d other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        String this$posTooltip = this.getPosTooltip();
        String other$posTooltip = other.getPosTooltip();
        if (this$posTooltip == null ? other$posTooltip != null : !this$posTooltip.equals(other$posTooltip)) {
            return false;
        }
        String this$dimTooltip = this.getDimTooltip();
        String other$dimTooltip = other.getDimTooltip();
        return !(this$dimTooltip == null ? other$dimTooltip != null : !this$dimTooltip.equals(other$dimTooltip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnderBlastCustomization;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dim = this.getDim();
        result = result * 59 + ($dim == null ? 43 : ((Object)$dim).hashCode());
        Vec3d $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        String $posTooltip = this.getPosTooltip();
        result = result * 59 + ($posTooltip == null ? 43 : $posTooltip.hashCode());
        String $dimTooltip = this.getDimTooltip();
        result = result * 59 + ($dimTooltip == null ? 43 : $dimTooltip.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EnderBlastCustomization(dim=" + this.getDim() + ", pos=" + this.getPos() + ", posTooltip=" + this.getPosTooltip() + ", dimTooltip=" + this.getDimTooltip() + ")";
    }

    @Generated
    public EnderBlastCustomization() {
    }
}

