/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.config.blast.ConfigBlast;
import icbm.classic.content.blast.BlastBeam;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastExothermic
extends BlastBeam {
    public BlastExothermic() {
        this.red = 0.7f;
        this.green = 0.3f;
        this.blue = 0.0f;
    }

    @Override
    protected void mutateBlocks(List<BlockPos> edits) {
        double radius = this.getBlastRadius();
        double radiusDecay = Math.max(1.0, radius * 0.3);
        double radiusEnsured = Math.max(1.0, radius * 0.1);
        for (BlockPos targetPosition : edits) {
            double delta_x = this.location.xi() - targetPosition.func_177958_n();
            double delta_y = this.location.yi() - targetPosition.func_177956_o();
            double delta_z = this.location.zi() - targetPosition.func_177952_p();
            double distance = Math.sqrt(delta_x * delta_x + delta_y * delta_y + delta_z * delta_z);
            double distanceScale = 1.0 - distance / radius;
            IBlockState blockState = this.field_77287_j.func_180495_p(targetPosition);
            Block block = blockState.func_177230_c();
            if (blockState.func_185904_a() == Material.field_151586_h || block == Blocks.field_150432_aD) {
                this.world().func_175698_g(targetPosition);
            }
            if (!(distance <= radiusDecay) && !(Math.random() < distanceScale)) continue;
            if (blockState.func_185904_a() == Material.field_151584_j || blockState.func_185904_a() == Material.field_151582_l || blockState.func_185904_a() == Material.field_151585_k) {
                if (!block.func_176200_f((IBlockAccess)this.world(), targetPosition) || Blocks.field_150480_ab.func_176196_c(this.world(), targetPosition)) {
                    this.world().func_175698_g(targetPosition);
                } else {
                    this.world().func_175656_a(targetPosition, Blocks.field_150480_ab.func_176223_P());
                }
            } else if (blockState.func_185904_a() == Material.field_151576_e) {
                if ((double)this.world().field_73012_v.nextFloat() > 0.9) {
                    this.world().func_180501_a(targetPosition, Blocks.field_150356_k.func_176223_P(), 3);
                } else if (this.world().field_73012_v.nextBoolean()) {
                    this.world().func_180501_a(targetPosition.func_177977_b(), Blocks.field_189877_df.func_176223_P(), 3);
                } else if (this.world().field_73012_v.nextBoolean() || distance <= radiusEnsured) {
                    BlastExothermic.placeNetherrack(this.field_77287_j, targetPosition);
                }
            } else if (blockState.func_185904_a() == Material.field_151595_p) {
                if (this.world().field_73012_v.nextBoolean()) {
                    this.world().func_180501_a(targetPosition.func_177977_b(), Blocks.field_150425_aM.func_176223_P(), 3);
                } else {
                    BlastExothermic.placeNetherrack(this.field_77287_j, targetPosition);
                }
            } else if (blockState.func_185904_a() == Material.field_151578_c || blockState.func_185904_a() == Material.field_151577_b) {
                BlastExothermic.placeNetherrack(this.field_77287_j, targetPosition);
            }
            if (!(Math.random() < distanceScale)) continue;
            BlastExothermic.tryPlaceFire(this.field_77287_j, targetPosition.func_177984_a(), false);
        }
    }

    private static void placeNetherrack(World world, BlockPos pos) {
        if (!world.func_180501_a(pos, Blocks.field_150424_aL.func_176223_P(), 3)) {
            System.out.println("Failed to place netherrack at " + pos);
        }
        BlastExothermic.tryPlaceFire(world, pos.func_177984_a(), true);
    }

    private static void tryPlaceFire(World world, BlockPos pos, boolean random) {
        IBlockState blockState;
        if ((!random || world.field_73012_v.nextBoolean()) && (blockState = world.func_180495_p(pos)).func_177230_c().func_176200_f((IBlockAccess)world, pos) && Blocks.field_150480_ab.func_176196_c(world, pos)) {
            world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 3);
        }
    }

    @Override
    public void onBlastCompleted() {
        super.onBlastCompleted();
        if (ConfigBlast.ALLOW_DAY_NIGHT && this.world().func_82736_K().func_82766_b("doDaylightCycle")) {
            this.world().func_72877_b(18000L);
        }
    }
}

