/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.actions;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.actions.IActionProvider;
import icbm.classic.api.actions.IPotentialAction;
import icbm.classic.api.data.meta.MetaTag;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public final class ActionProvider
implements IActionProvider,
INBTSerializable<NBTTagCompound> {
    private final Map<MetaTag, IPotentialAction> actions = new HashMap<MetaTag, IPotentialAction>();

    public ActionProvider withAction(MetaTag tag, IPotentialAction action) {
        this.actions.put(tag, action);
        return this;
    }

    @Override
    @Nullable
    public IPotentialAction getPotentialAction(MetaTag key) {
        return this.actions.get(key);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        this.actions.forEach((tag, action) -> {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74778_a("key", tag.getKey());
            entry.func_74782_a("value", (NBTBase)ICBMClassicAPI.ACTION_POTENTIAL_REGISTRY.save((IPotentialAction)action));
            list.func_74742_a((NBTBase)entry);
        });
        compound.func_74782_a("actions", (NBTBase)list);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("actions")) {
            NBTTagList list = nbt.func_150295_c("actions", 10);
            this.actions.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound entry = list.func_150305_b(i);
                String keyString = entry.func_74779_i("key");
                NBTTagCompound valueTag = entry.func_74775_l("value");
                MetaTag key = MetaTag.find(keyString);
                IPotentialAction value = ICBMClassicAPI.ACTION_POTENTIAL_REGISTRY.load(valueTag);
                this.actions.put(key, value);
            }
        }
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IActionProvider.class, (Capability.IStorage)new Capability.IStorage<IActionProvider>(){

            @Nullable
            public NBTBase writeNBT(Capability<IActionProvider> capability, IActionProvider instance, EnumFacing side) {
                return instance instanceof INBTSerializable ? ((INBTSerializable)instance).serializeNBT() : null;
            }

            public void readNBT(Capability<IActionProvider> capability, IActionProvider instance, EnumFacing side, NBTBase nbt) {
                if (instance instanceof INBTSerializable) {
                    ((INBTSerializable)instance).deserializeNBT(nbt);
                }
            }
        }, ActionProvider::new);
    }
}

