/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client;

import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.refs.ICBMExplosives;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.content.reg.ItemReg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ICBMCreativeTab
extends CreativeTabs {
    private final List<Item> definedTabItemsInOrder = new ArrayList<Item>();

    public ICBMCreativeTab(String name) {
        super(name);
    }

    public void init() {
        this.definedTabItemsInOrder.clear();
        this.orderItem(BlockReg.blockLaunchBase);
        this.orderItem(BlockReg.blockLaunchScreen);
        this.orderItem(BlockReg.blockLaunchSupport);
        this.orderItem(BlockReg.blockLaunchConnector);
        this.orderItem(BlockReg.blockCruiseLauncher);
        this.orderItem(BlockReg.blockEmpTower);
        this.orderItem(BlockReg.blockRadarStation);
        this.orderItem(BlockReg.blockConcrete);
        this.orderItem(BlockReg.blockReinforcedGlass);
        this.orderItem(BlockReg.blockSpikes);
        this.orderItem(ItemReg.itemRocketLauncher);
        this.orderItem(ItemReg.itemBallisticLauncher);
        this.orderItem(ItemReg.itemRadarGun);
        this.orderItem(ItemReg.itemRemoteDetonator);
        this.orderItem(ItemReg.itemLaserDetonator);
        this.orderItem(ItemReg.itemTracker);
        this.orderItem(ItemReg.itemSignalDisrupter);
        this.orderItem(ItemReg.itemDefuser);
        this.orderItem(ItemReg.itemExplosiveMissile);
        this.orderItem(ItemReg.itemSAM);
        this.orderItem(ItemReg.itemGrenade);
        this.orderItem(BlockReg.blockExplosive);
        this.orderItem(ItemReg.itemBombCart);
        for (Item item : ForgeRegistries.ITEMS) {
            if (item == null) continue;
            for (CreativeTabs tab : item.getCreativeTabs()) {
                if (tab != this || this.definedTabItemsInOrder.contains(item)) continue;
                this.orderItem(item);
            }
        }
    }

    private void orderItem(Block item) {
        this.orderItem(Item.func_150898_a((Block)item));
    }

    private void orderItem(Item item) {
        this.definedTabItemsInOrder.add(item);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_78018_a(NonNullList<ItemStack> list) {
        this.definedTabItemsInOrder.forEach(item -> this.collectSubItems((Item)item, list));
    }

    protected void collectSubItems(Item item, NonNullList<ItemStack> masterList) {
        if (item == null) {
            return;
        }
        NonNullList collectedItemStacks = NonNullList.func_191196_a();
        item.func_150895_a((CreativeTabs)this, collectedItemStacks);
        collectedItemStacks.sort(this::compareExplosives);
        masterList.addAll((Collection)collectedItemStacks);
    }

    private int compareExplosives(ItemStack itemA, ItemStack itemB) {
        IExplosive explosiveA = ICBMClassicHelpers.getExplosive(itemA);
        IExplosive explosiveB = ICBMClassicHelpers.getExplosive(itemB);
        if (explosiveA != null && explosiveB != null) {
            return this.compareExplosives(explosiveA, explosiveB);
        }
        return 0;
    }

    private int compareExplosives(IExplosive explosiveA, IExplosive explosiveB) {
        int tierB;
        IExplosiveData dataA = Optional.ofNullable(explosiveA.getExplosiveData()).orElse(ICBMExplosives.CONDENSED);
        IExplosiveData dataB = Optional.ofNullable(explosiveB.getExplosiveData()).orElse(ICBMExplosives.CONDENSED);
        int tierA = dataA.getTier().ordinal();
        if (tierA == (tierB = dataB.getTier().ordinal())) {
            return dataA.getRegistryID() - dataB.getRegistryID();
        }
        return tierA - tierB;
    }

    public ItemStack func_78016_d() {
        return new ItemStack(ItemReg.itemExplosiveMissile);
    }
}

