/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.api.reg.obj;

import icbm.classic.api.reg.obj.IBuilderRegistry;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public interface IBuildableObject {
    @Nonnull
    public ResourceLocation getRegistryKey();

    @Nonnull
    public IBuilderRegistry getRegistry();

    default public void register() {
        if (this.getRegistry().isLocked()) {
            return;
        }
        this.getRegistry().register(this.getRegistryKey(), () -> this);
    }

    @Nonnull
    default public String getTranslationKey() {
        return String.format("%s.%s", this.getRegistry().getUniqueName(), this.getRegistryKey());
    }

    @Nonnull
    default public ITextComponent getDisplayName() {
        return new TextComponentTranslation(this.getTranslationKey(), new Object[0]);
    }

    @Nonnull
    default public ITextComponent getTooltip() {
        return new TextComponentTranslation(this.getTranslationKey(), new Object[0]);
    }
}

