/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.api.data.meta;

import icbm.classic.ICBMClassic;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.util.NonNullList;

public final class MetaTag {
    private static final Map<String, MetaTag> TAG_MAP = new HashMap<String, MetaTag>();
    @Nonnull
    private final String key;
    @Nonnull
    private final String namespace;
    @Nonnull
    private final String path;
    private final MetaTag parent;
    private NonNullList<MetaTag> children;

    private MetaTag(@Nonnull String namespace, @Nonnull String path, @Nullable MetaTag parent) {
        this.key = namespace + ":" + path;
        this.path = path;
        this.namespace = namespace;
        this.parent = parent;
    }

    @Deprecated
    public String getDomain() {
        return this.getNamespace();
    }

    public static MetaTag find(String key) {
        return TAG_MAP.get(key);
    }

    public static MetaTag getOrCreateRoot(@Nonnull String namespace, @Nonnull String path) {
        return MetaTag.getOrCreate(null, namespace, path);
    }

    public static MetaTag getOrCreateSubTag(@Nonnull MetaTag parent, @Nonnull String subtype) {
        return MetaTag.getOrCreate(parent, parent.namespace, parent.path + "." + subtype);
    }

    public static MetaTag getOrCreate(@Nullable MetaTag parent, @Nonnull String namespace, @Nonnull String path) {
        MetaTag exist = MetaTag.find(namespace + ":" + path);
        if (exist != null) {
            return exist;
        }
        MetaTag metaTag = new MetaTag(namespace, path, parent);
        TAG_MAP.put(path, metaTag);
        ICBMClassic.logger().debug("MetaTag[{}] parent={}", (Object)metaTag.getKey(), (Object)(parent != null ? parent.getKey() : "nil"));
        if (parent != null) {
            parent.add(metaTag);
        }
        return metaTag;
    }

    private void add(MetaTag tag) {
        if (this.children == null) {
            this.children = NonNullList.func_191196_a();
        }
        this.children.add((Object)tag);
    }

    public boolean isChild(MetaTag tag) {
        return this.children != null && this.children.contains((Object)tag);
    }

    public boolean isSubType(MetaTag type) {
        return this.isChild(type) || this.children != null && this.children.stream().anyMatch(c -> c.isSubType(type));
    }

    public boolean isAssignable(MetaTag type) {
        return this.parent != null && this.parent.isAssignable(type) || type == this;
    }

    public MetaTag getTopParent() {
        return this.getTopParent(null);
    }

    public MetaTag getTopParent(MetaTag stop) {
        if (this.parent == null || stop != null && this.parent == stop) {
            return this;
        }
        return this.parent.getTopParent(stop);
    }

    @Nonnull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Nonnull
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public MetaTag getParent() {
        return this.parent;
    }

    @Generated
    public NonNullList<MetaTag> getChildren() {
        return this.children;
    }

    @Generated
    public void setChildren(NonNullList<MetaTag> children) {
        this.children = children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaTag)) {
            return false;
        }
        MetaTag other = (MetaTag)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        MetaTag this$parent = this.getParent();
        MetaTag other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        NonNullList<MetaTag> this$children = this.getChildren();
        NonNullList<MetaTag> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !this$children.equals(other$children));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        MetaTag $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        NonNullList<MetaTag> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : $children.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetaTag(key=" + this.getKey() + ", namespace=" + this.getNamespace() + ", path=" + this.getPath() + ", parent=" + this.getParent() + ", children=" + this.getChildren() + ")";
    }
}

