/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import icbm.classic.api.ICBMClassicAPI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class RecipeGeneration {
    public static void cartRecipes() {
        File saveFolder = new File(".", "recipes/bombcarts");
        saveFolder.mkdirs();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ICBMClassicAPI.EX_MINECART_REGISTRY.getExplosives().forEach(ex -> {
            File file = new File(saveFolder, ex.getRegistryKey().func_110623_a() + ".json");
            JsonObject recipeJson = new JsonObject();
            recipeJson.addProperty("type", "icbmclassic:explosive");
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("explosive", ex.getRegistryKey().toString());
            resultJson.addProperty("device", "icbmclassic:minecart");
            resultJson.addProperty("count", (Number)1);
            recipeJson.add("result", (JsonElement)resultJson);
            JsonArray patternJson = new JsonArray();
            patternJson.add("a");
            patternJson.add("c");
            recipeJson.add("pattern", (JsonElement)patternJson);
            JsonObject keyJson = new JsonObject();
            recipeJson.add("key", (JsonElement)keyJson);
            JsonObject key1 = new JsonObject();
            key1.addProperty("item", "minecraft:minecart");
            keyJson.add("c", (JsonElement)key1);
            JsonObject key2 = new JsonObject();
            key2.addProperty("type", "icbmclassic:explosive");
            key2.addProperty("explosive", ex.getRegistryKey().toString());
            keyJson.add("a", (JsonElement)key2);
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson((JsonElement)recipeJson, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void grenadeRecipes() {
        File saveFolder = new File(".", "recipes/grenades");
        saveFolder.mkdirs();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ICBMClassicAPI.EX_GRENADE_REGISTRY.getExplosives().forEach(ex -> {
            File file = new File(saveFolder, ex.getRegistryKey().func_110623_a() + ".json");
            JsonObject recipeJson = new JsonObject();
            recipeJson.addProperty("type", "icbmclassic:explosive");
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("explosive", ex.getRegistryKey().toString());
            resultJson.addProperty("device", "icbmclassic:grenade");
            resultJson.addProperty("count", (Number)1);
            recipeJson.add("result", (JsonElement)resultJson);
            JsonArray patternJson = new JsonArray();
            patternJson.add("s");
            patternJson.add("x");
            recipeJson.add("pattern", (JsonElement)patternJson);
            JsonObject keyJson = new JsonObject();
            recipeJson.add("key", (JsonElement)keyJson);
            JsonObject key1 = new JsonObject();
            key1.addProperty("type", "forge:ore_dict");
            key1.addProperty("ore", "string");
            keyJson.add("s", (JsonElement)key1);
            JsonObject key2 = new JsonObject();
            key2.addProperty("type", "icbmclassic:explosive");
            key2.addProperty("explosive", ex.getRegistryKey().toString());
            keyJson.add("x", (JsonElement)key2);
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson((JsonElement)recipeJson, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void missileRecipes() {
        File saveFolder = new File(".", "recipes/missiles");
        saveFolder.mkdirs();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ICBMClassicAPI.EX_MISSILE_REGISTRY.getExplosives().forEach(ex -> {
            File file = new File(saveFolder, ex.getRegistryKey().func_110623_a() + ".json");
            JsonObject recipeJson = new JsonObject();
            recipeJson.addProperty("type", "icbmclassic:explosive");
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("explosive", ex.getRegistryKey().toString());
            resultJson.addProperty("device", "icbmclassic:missile");
            resultJson.addProperty("count", (Number)1);
            recipeJson.add("result", (JsonElement)resultJson);
            JsonArray patternJson = new JsonArray();
            patternJson.add("mx");
            recipeJson.add("pattern", (JsonElement)patternJson);
            JsonObject keyJson = new JsonObject();
            recipeJson.add("key", (JsonElement)keyJson);
            JsonObject key1 = new JsonObject();
            key1.addProperty("type", "icbmclassic:explosive");
            key1.addProperty("device", "icbmclassic:missile.module");
            keyJson.add("m", (JsonElement)key1);
            JsonObject key2 = new JsonObject();
            key2.addProperty("type", "icbmclassic:explosive");
            key2.addProperty("device", "icbmclassic:block");
            key2.addProperty("explosive", ex.getRegistryKey().toString());
            keyJson.add("x", (JsonElement)key2);
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson((JsonElement)recipeJson, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

