/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;

public final class StringHelpers {
    public static final DecimalFormat NUMBER_FORMATTER_NO_DECIMALS = new DecimalFormat("#,###");
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,###.00");

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static String fitIntoSpaces(long num, int spaces) {
        return StringHelpers.padLeft(NUMBER_FORMATTER_NO_DECIMALS.format(num), spaces);
    }

    public static String formatTimeDifference(long start, long end) {
        return StringHelpers.formatNanoTime(end - start);
    }

    public static String formatNanoTime(long nano) {
        long m = nano / 1000000000L / 60L;
        long s = nano / 1000000000L % 60L;
        long ms = nano % 1000000000L / 1000000L;
        long us = nano % 1000000000L % 1000000L / 1000L;
        long ns = nano % 1000000000L % 1000000L % 1000L;
        String string = "";
        if (m > 0L) {
            string = string + StringHelpers.fitIntoSpaces(m, 4) + "m";
        }
        if (s > 0L) {
            string = string + StringHelpers.fitIntoSpaces(s, 4) + "s";
        }
        if (ms > 0L) {
            string = string + StringHelpers.fitIntoSpaces(ms, 4) + "ms";
        }
        if (us > 0L) {
            string = string + StringHelpers.fitIntoSpaces(us, 4) + "us";
        }
        if (ns > 0L) {
            string = string + StringHelpers.fitIntoSpaces(ns, 4) + "ns";
        }
        if (string.isEmpty()) {
            return "zero";
        }
        return string.trim();
    }

    public static String toString(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

