/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.render;

import CoroUtil.config.ConfigCoroUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.ShaderManager;
import extendedrenderer.particle.entity.EntityRotFX;
import extendedrenderer.shader.InstancedMeshParticle;
import extendedrenderer.shader.Matrix4fe;
import extendedrenderer.shader.MeshBufferManagerParticle;
import extendedrenderer.shader.ShaderEngine;
import extendedrenderer.shader.ShaderProgram;
import extendedrenderer.shader.Transformation;
import java.nio.FloatBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEmitter;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RotatingParticleManager {
    private static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    protected World world;
    public final LinkedHashMap<TextureAtlasSprite, List<ArrayDeque<Particle>[][]>> fxLayers = new LinkedHashMap();
    private final Queue<ParticleEmitter> particleEmitters = Queues.newArrayDeque();
    private final TextureManager renderer;
    private final Map<Integer, IParticleFactory> particleTypes = Maps.newHashMap();
    private final Queue<Particle> queueEntityFX = Queues.newArrayDeque();
    public static int debugParticleRenderCount;
    public static int lastAmountToRender;
    public static boolean useShaders;
    public static FloatBuffer projectionMatrixBuffer;
    public static FloatBuffer viewMatrixBuffer;
    public static boolean forceShaderReset;
    private static boolean forceVBO2Update;

    public static void markDirtyVBO2() {
        forceVBO2Update = true;
    }

    public RotatingParticleManager(World worldIn, TextureManager rendererIn) {
        this.world = worldIn;
        this.renderer = rendererIn;
    }

    public void initNewArrayData(TextureAtlasSprite sprite) {
        ArrayList<ArrayDeque[][]> list = new ArrayList<ArrayDeque[][]>();
        list.add(0, new ArrayDeque[4][]);
        list.add(1, new ArrayDeque[4][]);
        list.add(2, new ArrayDeque[4][]);
        for (ArrayDeque[][] arrayDequeArray : list) {
            for (int i = 0; i < 4; ++i) {
                arrayDequeArray[i] = new ArrayDeque[2];
                for (int j = 0; j < 2; ++j) {
                    arrayDequeArray[i][j] = Queues.newArrayDeque();
                }
            }
        }
        this.fxLayers.put(sprite, list);
    }

    public void registerParticle(int id, IParticleFactory particleFactory) {
        this.particleTypes.put(id, particleFactory);
    }

    public void emitParticleAtEntity(Entity entityIn, EnumParticleTypes particleTypes) {
        this.particleEmitters.add(new ParticleEmitter(this.world, entityIn, particleTypes));
    }

    @Nullable
    public Particle spawnEffectParticle(int particleId, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        Particle particle;
        IParticleFactory iparticlefactory = this.particleTypes.get(particleId);
        if (iparticlefactory != null && (particle = iparticlefactory.func_178902_a(particleId, this.world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters)) != null) {
            this.addEffect(particle);
            return particle;
        }
        return null;
    }

    public void addEffect(Particle effect) {
        if (effect == null) {
            return;
        }
        this.queueEntityFX.add(effect);
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            this.updateEffectLayer(i);
        }
        if (!this.particleEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (ParticleEmitter particleemitter : this.particleEmitters) {
                particleemitter.func_189213_a();
                if (particleemitter.func_187113_k()) continue;
                list.add(particleemitter);
            }
            this.particleEmitters.removeAll(list);
        }
        if (!this.queueEntityFX.isEmpty()) {
            RotatingParticleManager.markDirtyVBO2();
            Particle particle = this.queueEntityFX.poll();
            while (particle != null) {
                ArrayDeque<Particle>[][] entry;
                int j = particle.func_70537_b();
                int k = particle.func_187111_c() ? 0 : 1;
                int renderOrder = 0;
                if (particle instanceof EntityRotFX) {
                    renderOrder = ((EntityRotFX)particle).renderOrder;
                }
                if (!this.fxLayers.containsKey(particle.field_187119_C)) {
                    this.initNewArrayData(particle.field_187119_C);
                }
                if ((entry = this.fxLayers.get(particle.field_187119_C).get(renderOrder))[j][k].size() >= 16384) {
                    entry[j][k].getFirst().func_187112_i();
                    entry[j][k].removeFirst();
                }
                entry[j][k].add(particle);
                particle = this.queueEntityFX.poll();
            }
        }
    }

    private void updateEffectLayer(int layer) {
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry<TextureAtlasSprite, List<ArrayDeque<Particle>[][]>> entry1 : this.fxLayers.entrySet()) {
                for (ArrayDeque<Particle>[][] entry2 : entry1.getValue()) {
                    this.tickParticleList(entry2[layer][i]);
                }
            }
        }
    }

    private void tickParticleList(Queue<Particle> p_187240_1_) {
        if (!p_187240_1_.isEmpty()) {
            Iterator iterator = p_187240_1_.iterator();
            while (iterator.hasNext()) {
                Particle particle = (Particle)iterator.next();
                this.tickParticle(particle);
                if (particle.func_187113_k()) continue;
                iterator.remove();
                RotatingParticleManager.markDirtyVBO2();
            }
        }
    }

    private void tickParticle(final Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Rotating Particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
            final int i = particle.func_70537_b();
            crashreportcategory.func_189529_a("Rotating Particle", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return particle.toString();
                }
            });
            crashreportcategory.func_189529_a("Particle Type", (ICrashReportDetail)new ICrashReportDetail<String>(){

                public String call() throws Exception {
                    return i == 0 ? "MISC_TEXTURE" : (i == 1 ? "TERRAIN_TEXTURE" : (i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i));
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        boolean useParticleShaders = useShaders && ConfigCoroUtil.particleShaders;
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        Minecraft mc = Minecraft.func_71410_x();
        debugParticleRenderCount = 0;
        if (useParticleShaders) {
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.cloud256_test);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.cloud256_fire);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.cloud256);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.downfall3);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.cloud256_6);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.rain_white);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.snow);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.leaf);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.debris_1);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.debris_2);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.debris_3);
            MeshBufferManagerParticle.setupMeshForParticleIfMissing(ParticleRegistry.tumbleweed);
        }
        Transformation transformation = null;
        Matrix4fe viewMatrix = null;
        if (this.world.func_82737_E() % 20L < 10L) {
            // empty if block
        }
        int glCalls = 0;
        int trueRenderCount = 0;
        boolean bufferSize = false;
        int particles = 0;
        if (useParticleShaders) {
            boolean alternateCameraCapture;
            ShaderProgram shaderProgram = ShaderEngine.renderer.getShaderProgram("particle");
            transformation = ShaderEngine.renderer.transformation;
            shaderProgram.bind();
            Matrix4fe projectionMatrix = new Matrix4fe();
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2983, (FloatBuffer)buf);
            buf.rewind();
            Matrix4fe.get(projectionMatrix, 0, buf);
            boolean distantRendering = false;
            if (distantRendering) {
                float zNear = 0.05f;
                float zFar = (float)(mc.field_71474_y.field_151451_c * 16) * 4.0f;
                projectionMatrix.m22 = (zFar + zNear) / (zNear - zFar);
                projectionMatrix.m32 = (zFar + zFar) * zNear / (zNear - zFar);
            }
            if (alternateCameraCapture = true) {
                viewMatrix = new Matrix4fe();
                FloatBuffer buf2 = BufferUtils.createFloatBuffer((int)16);
                GL11.glGetFloat((int)2982, (FloatBuffer)buf2);
                buf2.rewind();
                Matrix4fe.get(viewMatrix, 0, buf2);
            }
            Matrix4fe modelViewMatrix = projectionMatrix.mul(viewMatrix);
            shaderProgram.setUniformEfficient("modelViewMatrixCamera", modelViewMatrix, viewMatrixBuffer);
            shaderProgram.setUniform("texture_sampler", 0);
            int glFogMode = GL11.glGetInteger((int)2917);
            int modeIndex = 0;
            if (glFogMode == 9729) {
                modeIndex = 0;
            } else if (glFogMode == 2048) {
                modeIndex = 1;
            } else if (glFogMode == 2049) {
                modeIndex = 2;
            }
            shaderProgram.setUniform("fogmode", modeIndex);
        }
        for (Map.Entry<TextureAtlasSprite, List<ArrayDeque<Particle>[][]>> entry1 : this.fxLayers.entrySet()) {
            InstancedMeshParticle mesh = null;
            if (useParticleShaders && (mesh = MeshBufferManagerParticle.getMesh(entry1.getKey())) == null) {
                MeshBufferManagerParticle.setupMeshForParticle(entry1.getKey());
                mesh = MeshBufferManagerParticle.getMesh(entry1.getKey());
            }
            if (mesh == null && useParticleShaders) continue;
            for (ArrayDeque<Particle>[][] entry : entry1.getValue()) {
                for (int i_nf = 0; i_nf < 3; ++i_nf) {
                    int i = i_nf;
                    for (int j = 0; j < 2; ++j) {
                        if (entry[i][j].isEmpty()) continue;
                        switch (j) {
                            case 0: {
                                GlStateManager.func_179132_a((boolean)false);
                                break;
                            }
                            case 1: {
                                GlStateManager.func_179132_a((boolean)true);
                            }
                        }
                        switch (i) {
                            default: {
                                this.renderer.func_110577_a(PARTICLE_TEXTURES);
                                break;
                            }
                            case 1: {
                                this.renderer.func_110577_a(TextureMap.field_110575_b);
                            }
                        }
                        if (useParticleShaders) {
                            mesh.initRender();
                            mesh.initRenderVBO1();
                            mesh.instanceDataBuffer.clear();
                            mesh.curBufferPos = 0;
                            particles = entry[i][j].size();
                            for (Particle particle : entry[i][j]) {
                                if (!(particle instanceof EntityRotFX)) continue;
                                EntityRotFX part = (EntityRotFX)particle;
                                part.renderParticleForShader(mesh, transformation, viewMatrix, entityIn, partialTicks, f, f4, f1, f2, f3);
                            }
                            mesh.instanceDataBuffer.limit(mesh.curBufferPos * 21);
                            OpenGlHelper.func_176072_g((int)34962, (int)mesh.instanceDataVBO);
                            ShaderManager.glBufferData(34962, mesh.instanceDataBuffer, 35048);
                            ShaderManager.glDrawElementsInstanced(4, mesh.getVertexCount(), 5125, 0L, mesh.curBufferPos);
                            ++glCalls;
                            trueRenderCount += mesh.curBufferPos;
                            OpenGlHelper.func_176072_g((int)34962, (int)0);
                            mesh.endRenderVBO1();
                            mesh.endRender();
                            continue;
                        }
                        Tessellator tessellator = Tessellator.func_178181_a();
                        BufferBuilder vertexbuffer = tessellator.func_178180_c();
                        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        for (Particle particle : entry[i][j]) {
                            if (particle instanceof EntityRotFX) {
                                EntityRotFX entityRotFX = (EntityRotFX)particle;
                            }
                            particle.func_180434_a(vertexbuffer, entityIn, partialTicks, f, f4, f1, f2, f3);
                            ++debugParticleRenderCount;
                        }
                        tessellator.func_78381_a();
                    }
                }
            }
        }
        forceVBO2Update = false;
        if (useParticleShaders) {
            ShaderEngine.renderer.getShaderProgram("particle").unbind();
        }
        if (ConfigCoroUtil.debugShaders && this.world.func_82737_E() % 60L == 0L) {
            System.out.println("particles: " + particles);
            System.out.println("debugParticleRenderCount: " + debugParticleRenderCount);
            System.out.println("trueRenderCount: " + trueRenderCount);
            System.out.println("glCalls: " + glCalls);
        }
    }

    public void renderLitParticles(Entity entityIn, float partialTick) {
        float f = (float)Math.PI / 180;
        float f1 = MathHelper.func_76134_b((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76126_a((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
        float f3 = -f2 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        float f4 = f1 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76134_b((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        for (Map.Entry<TextureAtlasSprite, List<ArrayDeque<Particle>[][]>> entry1 : this.fxLayers.entrySet()) {
            for (ArrayDeque<Particle>[][] entry : entry1.getValue()) {
                for (int i = 0; i < 2; ++i) {
                    ArrayDeque<Particle> queue = entry[3][i];
                    if (queue.isEmpty()) continue;
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder vertexbuffer = tessellator.func_178180_c();
                    for (Particle particle : queue) {
                        particle.func_180434_a(vertexbuffer, entityIn, partialTick, f1, f5, f2, f3, f4);
                    }
                }
            }
        }
    }

    public void clearEffects(@Nullable World worldIn) {
        this.world = worldIn;
        for (Map.Entry<TextureAtlasSprite, List<ArrayDeque<Particle>[][]>> entry1 : this.fxLayers.entrySet()) {
            for (ArrayDeque<Particle>[][] entry : entry1.getValue()) {
                for (int i = 0; i < entry.length; ++i) {
                    for (int j = 0; j < entry[i].length; ++j) {
                        if (entry[i][j] == null) continue;
                        entry[i][j].clear();
                    }
                }
            }
        }
        this.particleEmitters.clear();
    }

    public String getStatistics() {
        int count = 0;
        return "" + count;
    }

    static {
        projectionMatrixBuffer = BufferUtils.createFloatBuffer((int)16);
        viewMatrixBuffer = BufferUtils.createFloatBuffer((int)16);
        forceShaderReset = false;
        forceVBO2Update = false;
    }
}

