/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.forge.CULog;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.Vec3;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.biome.Biome;

public class CoroUtilMisc {
    public static void faceEntity(Entity entToRotate, Entity par1Entity, float par2, float par3) {
        double d2;
        double d0 = par1Entity.field_70165_t - entToRotate.field_70165_t;
        double d1 = par1Entity.field_70161_v - entToRotate.field_70161_v;
        if (par1Entity instanceof EntityLivingBase) {
            EntityLivingBase entityliving = (EntityLivingBase)par1Entity;
            d2 = entityliving.field_70163_u + (double)entityliving.func_70047_e() - (entToRotate.field_70163_u + (double)entToRotate.func_70047_e());
        } else {
            d2 = (par1Entity.func_174813_aQ().field_72338_b + par1Entity.func_174813_aQ().field_72337_e) / 2.0 - (entToRotate.field_70163_u + (double)entToRotate.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        entToRotate.field_70125_A = CoroUtilMisc.updateRotation(entToRotate.field_70125_A, f3, par3);
        entToRotate.field_70177_z = CoroUtilMisc.updateRotation(entToRotate.field_70177_z, f2, par2);
    }

    public static float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    public static BlockCoord vecToChunkCoords(Vec3 parVec) {
        return new BlockCoord(MathHelper.func_76128_c((double)parVec.xCoord), MathHelper.func_76128_c((double)parVec.yCoord), MathHelper.func_76128_c((double)parVec.zCoord));
    }

    public static BlockCoord addCoords(BlockCoord coords1, BlockCoord coords2) {
        return new BlockCoord(coords1.posX + coords2.posX, coords1.posY + coords2.posY, coords1.posZ + coords2.posZ);
    }

    public static void sendPlayerMsg(EntityPlayerMP entP, String msg) {
        CoroUtilMisc.sendCommandSenderMsg((ICommandSender)entP, msg);
    }

    public static void sendCommandSenderMsg(ICommandSender entP, String msg) {
        entP.func_145747_a((ITextComponent)new TextComponentString(msg));
    }

    public static float adjVal(float source, float target, float adj) {
        if (source < target) {
            if ((source += adj) > target) {
                source = target;
            }
        } else if (source > target && (source -= adj) < target) {
            source = target;
        }
        return source;
    }

    public static void fixBadBiomeEntitySpawns() {
        for (Biome biome : Biome.field_185377_q) {
            for (EnumCreatureType type : EnumCreatureType.values()) {
                List list = biome.func_76747_a(type);
                boolean found = false;
                String str = "";
                int totalWeight = 0;
                for (Biome.SpawnListEntry entry : list) {
                    totalWeight += entry.field_76292_a;
                    if (entry.field_76292_a != 0) continue;
                    found = true;
                    str = str + entry.field_76300_b.getName() + ", ";
                }
                if (!found || totalWeight != 0) continue;
                CULog.log("Detected issue for entity(s)" + str);
                CULog.log("Biome '" + biome.field_76791_y + "' for EnumCreatureType '" + type.name() + "', SpawnListEntry size: " + list.size());
                CULog.log("Clearing relevant spawnableList to fix issue");
                if (type == EnumCreatureType.MONSTER) {
                    biome.field_76761_J.clear();
                    continue;
                }
                if (type == EnumCreatureType.CREATURE) {
                    biome.field_76762_K.clear();
                    continue;
                }
                if (type == EnumCreatureType.WATER_CREATURE) {
                    biome.field_76755_L.clear();
                    continue;
                }
                if (type != EnumCreatureType.AMBIENT) continue;
                biome.field_82914_M.clear();
            }
        }
    }

    public static void removeAllModifiers(IAttributeInstance attributeInstance) {
        Collection collection = attributeInstance.func_111122_c();
        if (collection != null) {
            for (AttributeModifier attributemodifier : Lists.newArrayList((Iterable)collection)) {
                attributeInstance.func_111124_b(attributemodifier);
            }
        }
    }
}

