/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.forge.CULog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;

public class CoroUtilCompatibility {
    private static boolean tanInstalled = false;
    private static boolean checkTAN = true;
    private static boolean sereneSeasonsInstalled = false;
    private static boolean checksereneSeasons = true;
    private static boolean lycanitesMobsInstalled = false;
    private static boolean checkLycanitesMobs = true;
    private static Class class_TAN_ASMHelper = null;
    private static Method method_TAN_getFloatTemperature = null;
    private static Class class_SereneSeasons_ASMHelper = null;
    private static Method method_sereneSeasons_getFloatTemperature = null;
    private static boolean enableFlyingSupport = false;
    private static Class class_LycanitesMobs_Entity = null;
    private static Class class_LycanitesMobs_DirectNavigator = null;
    private static Field field_LycanitesMobs_directNavigator = null;
    private static Method method_LycanitesMobs_useDirectNavigator = null;
    private static Method method_LycanitesMobs_setTargetPosition = null;
    public static int lastPowerVal = -1;

    public static boolean shouldSnowAt(World world, BlockPos pos) {
        return false;
    }

    public static float getAdjustedTemperature(World world, Biome biome, BlockPos pos) {
        if (CoroUtilCompatibility.isTANInstalled()) {
            try {
                if (method_TAN_getFloatTemperature == null) {
                    method_TAN_getFloatTemperature = class_TAN_ASMHelper.getDeclaredMethod("getFloatTemperature", Biome.class, BlockPos.class);
                }
                return ((Float)method_TAN_getFloatTemperature.invoke(null, biome, pos)).floatValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                tanInstalled = false;
                return biome.func_180626_a(pos);
            }
        }
        if (CoroUtilCompatibility.isSereneSeasonsInstalled()) {
            try {
                if (method_sereneSeasons_getFloatTemperature == null) {
                    method_sereneSeasons_getFloatTemperature = class_SereneSeasons_ASMHelper.getDeclaredMethod("getFloatTemperature", World.class, Biome.class, BlockPos.class);
                }
                return ((Float)method_sereneSeasons_getFloatTemperature.invoke(null, world, biome, pos)).floatValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                sereneSeasonsInstalled = false;
                return biome.func_180626_a(pos);
            }
        }
        return biome.func_180626_a(pos);
    }

    public static boolean isTANInstalled() {
        if (checkTAN) {
            try {
                checkTAN = false;
                class_TAN_ASMHelper = Class.forName("toughasnails.season.SeasonASMHelper");
                if (class_TAN_ASMHelper != null) {
                    tanInstalled = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            CULog.log("CoroUtil detected Tough As Nails Seasons " + (tanInstalled ? "Installed" : "Not Installed") + " for use");
        }
        return tanInstalled;
    }

    public static boolean isSereneSeasonsInstalled() {
        if (checksereneSeasons) {
            try {
                checksereneSeasons = false;
                class_SereneSeasons_ASMHelper = Class.forName("sereneseasons.api.season.BiomeHooks");
                if (class_SereneSeasons_ASMHelper != null) {
                    sereneSeasonsInstalled = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            CULog.log("CoroUtil detected Serene Seasons " + (sereneSeasonsInstalled ? "Installed" : "Not Installed") + " for use");
        }
        return sereneSeasonsInstalled;
    }

    public static boolean isLycanitesMobsInstalled() {
        if (checkLycanitesMobs) {
            try {
                checkLycanitesMobs = false;
                class_LycanitesMobs_Entity = Class.forName("com.lycanitesmobs.core.entity.EntityCreatureBase");
                if (class_LycanitesMobs_Entity != null) {
                    lycanitesMobsInstalled = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            CULog.log("CoroUtil detected Lycanites Mobs " + (lycanitesMobsInstalled ? "Installed" : "Not Installed") + " for use");
        }
        return lycanitesMobsInstalled;
    }

    public static void testPowerInfo(EntityPlayer player, BlockPos pos) {
        TileEntity tEnt = player.field_70170_p.func_175625_s(pos);
        if (tEnt != null) {
            int value = -1;
            IEnergyStorage cap = (IEnergyStorage)tEnt.getCapability(CapabilityEnergy.ENERGY, null);
            if (cap != null) {
                value = cap.getEnergyStored();
                player.func_145747_a((ITextComponent)new TextComponentString("cap power stored: " + value));
                if (lastPowerVal != -1) {
                    player.func_145747_a((ITextComponent)new TextComponentString("relative power change: " + (value - lastPowerVal)));
                }
                lastPowerVal = value;
            } else {
                try {
                    boolean success = true;
                    Class<?> classTry = Class.forName("crazypants.enderio.base.power.ILegacyPoweredTile");
                    if (classTry == null) {
                        player.func_145747_a((ITextComponent)new TextComponentString("EIO class not found, trying cofh"));
                        classTry = Class.forName("cofh.redstoneflux.api.IEnergyStorage");
                        if (classTry == null) {
                            player.func_145747_a((ITextComponent)new TextComponentString("cofh class not found"));
                        }
                    }
                    if (classTry != null) {
                        Method method = classTry.getDeclaredMethod("getEnergyStored", new Class[0]);
                        if (method != null) {
                            value = (Integer)method.invoke((Object)tEnt, new Object[0]);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString("method not found"));
                            success = false;
                        }
                    } else {
                        success = false;
                    }
                    if (success) {
                        player.func_145747_a((ITextComponent)new TextComponentString("non cap power stored: " + value));
                        if (lastPowerVal != -1) {
                            player.func_145747_a((ITextComponent)new TextComponentString("relative power change: " + (value - lastPowerVal)));
                        }
                        lastPowerVal = value;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static boolean tryPathToXYZModCompat(EntityLiving ent, int x, int y, int z, double speed) {
        boolean invokedCustom = false;
        boolean successCustom = false;
        if (enableFlyingSupport && CoroUtilCompatibility.isLycanitesMobsInstalled()) {
            try {
                if (class_LycanitesMobs_DirectNavigator == null) {
                    class_LycanitesMobs_DirectNavigator = Class.forName("com.lycanitesmobs.core.entity.ai.DirectNavigator");
                }
                if (method_LycanitesMobs_useDirectNavigator == null) {
                    method_LycanitesMobs_useDirectNavigator = class_LycanitesMobs_Entity.getDeclaredMethod("useDirectNavigator", new Class[0]);
                }
                if (method_LycanitesMobs_setTargetPosition == null) {
                    method_LycanitesMobs_setTargetPosition = class_LycanitesMobs_DirectNavigator.getDeclaredMethod("setTargetPosition", BlockPos.class, Double.TYPE);
                }
                if (field_LycanitesMobs_directNavigator == null) {
                    field_LycanitesMobs_directNavigator = class_LycanitesMobs_Entity.getDeclaredField("directNavigator");
                }
                if (ent.getClass().isAssignableFrom(class_LycanitesMobs_Entity) && ((Boolean)method_LycanitesMobs_useDirectNavigator.invoke((Object)ent, new Object[0])).booleanValue()) {
                    Object directNavigator = field_LycanitesMobs_directNavigator.get(ent);
                    invokedCustom = true;
                    successCustom = (Boolean)method_LycanitesMobs_setTargetPosition.invoke(directNavigator, new BlockPos(x, y, z), speed);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                lycanitesMobsInstalled = false;
                return false;
            }
        }
        if (!invokedCustom) {
            return CoroUtilCompatibility.tryPathToXYZVanilla(ent, x, y, z, speed);
        }
        return successCustom;
    }

    public static boolean tryPathToXYZVanilla(EntityLiving ent, int x, int y, int z, double speed) {
        return ent.func_70661_as().func_75492_a((double)x, (double)y, (double)z, speed);
    }

    public static boolean isHWMonstersInstalled() {
        return Loader.isModLoaded((String)"hw_monsters");
    }

    public static boolean isHWInvasionsInstalled() {
        return Loader.isModLoaded((String)"hw_inv");
    }

    public static boolean canTornadoGrabBlockRefinedRules(IBlockState state) {
        ResourceLocation registeredName = state.func_177230_c().getRegistryName();
        return !registeredName.func_110624_b().equals("dynamictrees") || !registeredName.func_110623_a().contains("rooty") && !registeredName.func_110623_a().contains("branch");
    }
}

