/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.test;

import CoroUtil.music.Melody;
import CoroUtil.music.MusicPlayer;
import CoroUtil.music.NoteHelper;
import CoroUtil.music.Sequencer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;

public class SoundTest {
    public int ticksPlaying = 0;
    public int curBar = 0;
    public int curPosInBar = 0;
    public int tickRate = 0;
    public boolean active = false;
    public Synthesizer synth;
    public MidiChannel[] mc;
    public Instrument[] instr;
    public List<Melody> listMelodies = new ArrayList<Melody>();

    public void start() {
        try {
            this.ticksPlaying = 0;
            this.curBar = 0;
            this.curPosInBar = 0;
            this.synth = MidiSystem.getSynthesizer();
            this.synth.open();
            this.mc = this.synth.getChannels();
            this.instr = this.synth.getDefaultSoundbank().getInstruments();
            for (int i = 0; i < this.instr.length; ++i) {
                System.out.println(i + ": " + this.instr[i]);
            }
            MusicPlayer.initMidi();
            Sequencer seq = new Sequencer();
            seq.tempo = 120;
            Melody m1 = new Melody(seq);
            m1.setMidiData(5, 48);
            m1.length = NoteHelper.NOTE_HALF;
            m1.octive = 6;
            m1.addNote(0, 0.0f, NoteHelper.NOTE_SIXTEENTH);
            m1.addNote(2, 0.0625f, NoteHelper.NOTE_SIXTEENTH);
            m1.addNote(4, 0.125f, NoteHelper.NOTE_SIXTEENTH);
            m1.addNote(5, 0.1875f, NoteHelper.NOTE_SIXTEENTH);
            m1.addNote(5, 0.375f, NoteHelper.NOTE_SIXTEENTH);
            m1.addNote(5, 0.5f, NoteHelper.NOTE_SIXTEENTH);
            m1.addNote(5, 0.625f, NoteHelper.NOTE_SIXTEENTH);
            seq.listMelodies.add(m1);
            m1 = new Melody(seq);
            m1.setMidiData(5, 48);
            m1.length = NoteHelper.NOTE_SIXTEENTH;
            m1.octive = 4;
            m1.addNote(0, 0.0f, NoteHelper.NOTE_SIXTEENTH);
            m1.addNote(4, 0.0f, NoteHelper.NOTE_SIXTEENTH);
            m1.addNote(7, 0.0f, NoteHelper.NOTE_SIXTEENTH);
            seq.listMelodies.add(m1);
            MusicPlayer.startSequence(seq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void tick() {
        ++this.ticksPlaying;
        this.tickRate = 40;
        this.curBar = this.ticksPlaying / this.tickRate;
        this.curPosInBar = this.ticksPlaying % this.tickRate;
        Random rand = new Random();
        ArrayList<Integer> listNotes = new ArrayList<Integer>();
        listNotes.add(0);
        listNotes.add(2);
        listNotes.add(4);
        listNotes.add(5);
        int s1 = 5;
        int s2 = 8;
        ArrayList<Integer> listTimings = new ArrayList<Integer>();
        listTimings.add(s1);
        listTimings.add(s1 * 2);
        listTimings.add(s1 * 3);
        listTimings.add(s1 * 3 + s2);
        listTimings.add(s1 * 3 + s2 * 2);
        listTimings.add(s1 * 3 + s2 * 3);
        try {
            int chan = 5;
            this.mc[chan].programChange(0, this.instr[100].getPatch().getProgram());
            if (listTimings.contains(this.curPosInBar)) {
                this.mc[chan].allNotesOff();
                int octive = 4;
                this.mc[chan].noteOn(octive * 13 + (Integer)listNotes.get(this.curBar % listNotes.size()), 100);
            }
            chan = 9;
            this.mc[chan].programChange(this.instr[0].getPatch().getProgram());
            if (this.curPosInBar < 40) {
                if (this.curPosInBar % 5 == 0) {
                    this.mc[chan].noteOn(36, 600);
                }
                if (this.curPosInBar % 10 == 0) {
                    this.mc[chan].noteOn(31, 600);
                }
            }
            if (listTimings.contains(this.curPosInBar / 2)) {
                int n = 2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() {
        this.active = false;
        MusicPlayer.stopAllSequences();
        try {
            for (int i = 0; i < this.mc.length; ++i) {
                this.mc[i].allNotesOff();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

