/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.item;

import info.tehnut.soulshardsrespawn.SoulShards;
import info.tehnut.soulshardsrespawn.api.IShardTier;
import info.tehnut.soulshardsrespawn.api.ISoulShard;
import info.tehnut.soulshardsrespawn.block.TileEntitySoulCage;
import info.tehnut.soulshardsrespawn.core.RegistrarSoulShards;
import info.tehnut.soulshardsrespawn.core.data.Binding;
import info.tehnut.soulshardsrespawn.core.data.Tier;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemSoulShard
extends Item
implements ISoulShard {
    private static final Method GET_ENTITY_ID_METHOD = ReflectionHelper.findMethod(MobSpawnerBaseLogic.class, (String)"getEntityId", (String)"func_190895_g", (Class[])new Class[0]);

    public ItemSoulShard() {
        this.func_77655_b("soulshardsrespawn.soul_shard");
        this.func_77637_a(SoulShards.TAB_SS);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("soulshardsrespawn", "bound"), (stack, worldIn, entityIn) -> this.getBinding(stack) != null ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("soulshardsrespawn", "tier"), (stack, world, entity) -> {
            Binding binding = this.getBinding(stack);
            if (binding == null) {
                return 0.0f;
            }
            return Float.valueOf("0." + Tier.INDEXED.indexOf(binding.getTier())).floatValue();
        });
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return EnumActionResult.PASS;
        }
        if (state.func_177230_c() instanceof BlockMobSpawner) {
            if (!SoulShards.CONFIG.allowSpawnerAbsorption()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.soulshardsrespawn.absorb_disabled", new Object[0]), true);
                return EnumActionResult.PASS;
            }
            if (binding.getKills() >= Tier.maxKills) {
                return EnumActionResult.PASS;
            }
            TileEntityMobSpawner mobSpawner = (TileEntityMobSpawner)world.func_175625_s(pos);
            if (mobSpawner == null) {
                return EnumActionResult.PASS;
            }
            try {
                ResourceLocation entityId = (ResourceLocation)GET_ENTITY_ID_METHOD.invoke((Object)mobSpawner.func_145881_a(), new Object[0]);
                if (!SoulShards.CONFIG.isEntityEnabled(entityId)) {
                    return EnumActionResult.PASS;
                }
                if (entityId == null || binding.getBoundEntity() == null || !binding.getBoundEntity().equals((Object)entityId)) {
                    return EnumActionResult.FAIL;
                }
                this.updateBinding(stack, binding.addKills(SoulShards.CONFIG.getAbsorptionBonus()));
                world.func_175655_b(pos, false);
                return EnumActionResult.SUCCESS;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (state.func_177230_c() == RegistrarSoulShards.SOUL_CAGE) {
            if (binding.getBoundEntity() == null) {
                return EnumActionResult.FAIL;
            }
            TileEntitySoulCage cage = (TileEntitySoulCage)world.func_175625_s(pos);
            if (cage == null) {
                return EnumActionResult.PASS;
            }
            IItemHandler itemHandler = (IItemHandler)cage.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (itemHandler != null && itemHandler.getStackInSlot(0).func_190926_b()) {
                ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack.func_77946_l(), (boolean)false);
                cage.func_70296_d();
                player.func_184611_a(hand, ItemStack.field_190927_a);
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        for (IShardTier tier : Tier.INDEXED) {
            ItemStack stack = new ItemStack((Item)this);
            Binding binding = new Binding(null, tier.getKillRequirement());
            this.updateBinding(stack, binding);
            items.add((Object)stack);
        }
        if (SoulShards.CONFIG.explodeCreativeTab()) {
            Binding binding = new Binding(null, Tier.maxKills);
            SoulShards.CONFIG.getEntityMap().entrySet().stream().filter(e -> (Boolean)e.getValue() != false || SoulShards.CONFIG.ignoreBlacklistForTab()).forEach(e -> {
                binding.setBoundEntity((ResourceLocation)e.getKey());
                ItemStack stack = new ItemStack((Item)this);
                this.updateBinding(stack, binding);
                items.add((Object)stack);
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        EntityEntry entityEntry;
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return;
        }
        if (binding.getBoundEntity() != null && (entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(binding.getBoundEntity())) != null) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.soulshardsrespawn.bound", (Object[])new Object[]{entityEntry.getName()}));
        }
        tooltip.add(I18n.func_135052_a((String)"tooltip.soulshardsrespawn.tier", (Object[])new Object[]{binding.getTier().getIndex()}));
        tooltip.add(I18n.func_135052_a((String)"tooltip.soulshardsrespawn.kills", (Object[])new Object[]{binding.getKills()}));
        if (flag.func_194127_a() && binding.getOwner() != null) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.soulshardsrespawn.owner", (Object[])new Object[]{binding.getOwner().toString()}));
        }
    }

    public String func_77667_c(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        return super.func_77667_c(stack) + (binding == null || binding.getBoundEntity() == null ? "_unbound" : "");
    }

    public boolean func_77636_d(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        return binding != null && binding.getKills() >= Tier.maxKills;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        return SoulShards.CONFIG.displayDurabilityBar() && binding != null && binding.getKills() < Tier.maxKills;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return 1.0;
        }
        return 1.0 - (double)binding.getKills() / (double)Tier.maxKills;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return super.getRGBDurabilityForDisplay(stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getBinding(stack) == null ? 64 : 1;
    }

    @Override
    @Nullable
    public Binding getBinding(ItemStack stack) {
        return Binding.fromNBT(stack);
    }

    public void updateBinding(ItemStack stack, Binding binding) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("binding", (NBTBase)binding.serializeNBT());
    }
}

