/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.block;

import info.tehnut.soulshardsrespawn.SoulShards;
import info.tehnut.soulshardsrespawn.api.CageSpawnEvent;
import info.tehnut.soulshardsrespawn.block.BlockSoulCage;
import info.tehnut.soulshardsrespawn.core.RegistrarSoulShards;
import info.tehnut.soulshardsrespawn.core.data.Binding;
import info.tehnut.soulshardsrespawn.item.ItemSoulShard;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySoulCage
extends TileEntity
implements ITickable {
    ItemStackHandler inventory = new SoulCageInventory();
    private int activeTime;

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ActionResult<Binding> result = this.canSpawn();
        if (result.func_188397_a() != EnumActionResult.SUCCESS) {
            this.setState(false);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            return;
        }
        this.setState(true);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        ++this.activeTime;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        if (this.activeTime % ((Binding)result.func_188398_b()).getTier().getCooldown() == 0) {
            this.spawnEntities();
        }
    }

    private void spawnEntities() {
        Binding binding = this.getBinding();
        if (binding == null || binding.getBoundEntity() == null) {
            return;
        }
        EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(binding.getBoundEntity());
        block0: for (int i = 0; i < binding.getTier().getSpawnAmount(); ++i) {
            for (int attempts = 0; attempts < 5; ++attempts) {
                CageSpawnEvent event;
                double x = (double)this.func_174877_v().func_177958_n() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 4.0;
                double y = this.func_174877_v().func_177956_o() + this.func_145831_w().field_73012_v.nextInt(3) - 1;
                double z = (double)this.func_174877_v().func_177952_p() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 4.0;
                BlockPos spawnAt = new BlockPos(x, y, z);
                EntityLiving entityLiving = (EntityLiving)entityEntry.newInstance(this.func_145831_w());
                if (entityLiving == null || binding.getTier().checkLight() && !this.canSpawnInLight(entityLiving, spawnAt)) continue;
                entityLiving.func_70012_b((double)spawnAt.func_177958_n(), (double)spawnAt.func_177956_o(), (double)spawnAt.func_177952_p(), MathHelper.func_76142_g((float)(this.func_145831_w().field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityLiving.getEntityData().func_74757_a("cageBorn", true);
                entityLiving.field_98038_p = true;
                entityLiving.func_110163_bv();
                if (!entityLiving.func_70058_J() || entityLiving.field_70128_L || this.hasReachedSpawnCap(entityLiving) || !SoulShards.CONFIG.allowBossSpawns() && !entityLiving.func_184222_aU() || MinecraftForge.EVENT_BUS.post((Event)(event = new CageSpawnEvent(binding, this.inventory.getStackInSlot(0), (EntityLivingBase)entityLiving)))) continue;
                this.func_145831_w().func_72838_d((Entity)entityLiving);
                entityLiving.func_180482_a(this.func_145831_w().func_175649_E(spawnAt), null);
                continue block0;
            }
        }
    }

    private ActionResult<Binding> canSpawn() {
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_82736_K().func_82766_b("allowCageSpawns")) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, null);
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != RegistrarSoulShards.SOUL_CAGE) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, null);
        }
        ItemStack shardStack = this.inventory.getStackInSlot(0);
        if (shardStack.func_190926_b() || !(shardStack.func_77973_b() instanceof ItemSoulShard)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, null);
        }
        Binding binding = ((ItemSoulShard)shardStack.func_77973_b()).getBinding(shardStack);
        if (binding == null || binding.getBoundEntity() == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)binding);
        }
        if (binding.getTier().getSpawnAmount() == 0) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)binding);
        }
        if (SoulShards.CONFIG.requireOwnerOnline() && !this.ownerOnline()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)binding);
        }
        if (!SoulShards.CONFIG.isEntityEnabled(binding.getBoundEntity())) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)binding);
        }
        if (!SoulShards.CONFIG.requireRedstoneSignal() ? (Boolean)state.func_177229_b(BlockSoulCage.POWERED) != false && binding.getTier().checkRedstone() : (Boolean)state.func_177229_b(BlockSoulCage.POWERED) == false) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)binding);
        }
        if (binding.getTier().checkPlayer() && this.func_145831_w().func_184137_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 16.0, false) == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)binding);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)binding);
    }

    private boolean canSpawnInLight(EntityLiving entityLiving, BlockPos pos) {
        return !(entityLiving instanceof IMob) || this.field_145850_b.func_175671_l(pos) <= 8;
    }

    private boolean hasReachedSpawnCap(EntityLiving living) {
        AxisAlignedBB box = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 16), (double)(this.func_174877_v().func_177956_o() - 16), (double)(this.func_174877_v().func_177952_p() - 16), (double)(this.func_174877_v().func_177958_n() + 16), (double)(this.func_174877_v().func_177956_o() + 16), (double)(this.func_174877_v().func_177952_p() + 16));
        int mobCount = this.func_145831_w().func_175647_a(living.getClass(), box, e -> e != null && e.getEntityData().func_74767_n("cageBorn")).size();
        return mobCount >= SoulShards.CONFIG.getSpawnCap();
    }

    public void setState(boolean active) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a(BlockSoulCage.ACTIVE, (Comparable)Boolean.valueOf(active)));
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.activeTime = compound.func_74762_e("activeTime");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("activeTime", this.activeTime);
        return super.func_189515_b(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -999, this.func_189515_b(new NBTTagCompound()));
    }

    @SideOnly(value=Side.CLIENT)
    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public final void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Nullable
    public Binding getBinding() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSoulShard)) {
            return null;
        }
        return ((ItemSoulShard)stack.func_77973_b()).getBinding(stack);
    }

    public boolean ownerOnline() {
        Binding binding = this.getBinding();
        return binding != null && binding.getOwner() != null && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(binding.getOwner()) == null;
    }

    public static class SoulCageInventory
    extends ItemStackHandler {
        public SoulCageInventory() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!(stack.func_77973_b() instanceof ItemSoulShard)) {
                return stack;
            }
            Binding binding = ((ItemSoulShard)stack.func_77973_b()).getBinding(stack);
            if (binding == null || binding.getBoundEntity() == null || !SoulShards.CONFIG.isEntityEnabled(binding.getBoundEntity())) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

