/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.network;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.bdew.lib.BdLib$;
import net.bdew.lib.Misc$;
import net.bdew.lib.network.BaseMessage;
import net.bdew.lib.network.NetChannel$ClientHandler$;
import net.bdew.lib.network.NetChannel$ServerHandler$;
import net.bdew.lib.network.SerializedMessageCodec;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001-\u0011!BT3u\u0007\"\fgN\\3m\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0005\u00151\u0011a\u00017jE*\u0011q\u0001C\u0001\u0005E\u0012,wOC\u0001\n\u0003\rqW\r^\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005!a.Y7f+\u0005)\u0002C\u0001\f\u001a\u001d\tiq#\u0003\u0002\u0019\u001d\u00051\u0001K]3eK\u001aL!AG\u000e\u0003\rM#(/\u001b8h\u0015\tAb\u0002\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0015q\u0017-\\3!\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011e\t\t\u0003E\u0001i\u0011A\u0001\u0005\u0006'y\u0001\r!\u0006\u0005\nK\u0001\u0001\r\u00111A\u0005\u0002\u0019\n\u0001b\u00195b]:,Gn]\u000b\u0002OA!\u0001&L\u0018:\u001b\u0005I#B\u0001\u0016,\u0003\u0011)H/\u001b7\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\b\u000b:,X.T1q!\t\u0001t'D\u00012\u0015\t\u00114'\u0001\u0006sK2\fWO\\2iKJT!\u0001N\u001b\u0002\u0007\u0019lGN\u0003\u00027\u0011\u0005qQ.\u001b8fGJ\fg\r\u001e4pe\u001e,\u0017B\u0001\u001d2\u0005\u0011\u0019\u0016\u000eZ3\u0011\u0005irT\"A\u001e\u000b\u0005\ra$BA\u001f4\u0003\u0019\u0019w.\\7p]&\u0011qh\u000f\u0002\u0013\r6cU)\u001c2fI\u0012,Gm\u00115b]:,G\u000eC\u0005B\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u0006a1\r[1o]\u0016d7o\u0018\u0013fcR\u00111I\u0012\t\u0003\u001b\u0011K!!\u0012\b\u0003\tUs\u0017\u000e\u001e\u0005\b\u000f\u0002\u000b\t\u00111\u0001(\u0003\rAH%\r\u0005\u0007\u0013\u0002\u0001\u000b\u0015B\u0014\u0002\u0013\rD\u0017M\u001c8fYN\u0004S\u0001B&\u0001\u00011\u0013q!T3tg\u0006<W\rE\u0002#\u001b>K!A\u0014\u0002\u0003\u0017\t\u000b7/Z'fgN\fw-Z\u0007\u0002\u0001\u001d)\u0011\u000b\u0001E\u0001%\u0006i1+\u001a:wKJD\u0015M\u001c3mKJ\u0004\"aT*\u0007\u000bQ\u0003\u0001\u0012A+\u0003\u001bM+'O^3s\u0011\u0006tG\r\\3s'\t\u0019f\u000bE\u0002X=\u0002l\u0011\u0001\u0017\u0006\u00033j\u000bqa\u00195b]:,GN\u0003\u0002\\9\u0006)a.\u001a;us*\tQ,\u0001\u0002j_&\u0011q\f\u0017\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005=S\u0005\"B\u0010T\t\u0003\u0011G#\u0001*\t\u000b\u0011\u001cF\u0011A3\u0002\u0019\rD\u0017M\u001c8fYJ+\u0017\r\u001a\u0019\u0015\u0007\r37\u000eC\u0003hG\u0002\u0007\u0001.A\u0002dib\u0004\"aV5\n\u0005)D&!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u0006Y\u000e\u0004\r\u0001Y\u0001\u0004[N<w!\u00028\u0001\u0011\u0003y\u0017!D\"mS\u0016tG\u000fS1oI2,'\u000f\u0005\u0002Pa\u001a)\u0011\u000f\u0001E\u0001e\ni1\t\\5f]RD\u0015M\u001c3mKJ\u001c\"\u0001\u001d,\t\u000b}\u0001H\u0011\u0001;\u0015\u0003=DQ\u0001\u001a9\u0005\u0002Y$2aQ<y\u0011\u00159W\u000f1\u0001i\u0011\u0015aW\u000f1\u0001a\u0011\u0015Q\b\u0001\"\u0001|\u0003\u0011Ig.\u001b;\u0015\u0003\rCq! \u0001A\u0002\u0013\u0005a0A\u0006dY&,g\u000e^\"iC&tW#A@\u0011\u000b5\t\t\u0001Y\"\n\u0007\u0005\raBA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o\u0011%\t9\u0001\u0001a\u0001\n\u0003\tI!A\bdY&,g\u000e^\"iC&tw\fJ3r)\r\u0019\u00151\u0002\u0005\t\u000f\u0006\u0015\u0011\u0011!a\u0001\u007f\"9\u0011q\u0002\u0001!B\u0013y\u0018\u0001D2mS\u0016tGo\u00115bS:\u0004\u0003\"CA\n\u0001\u0001\u0007I\u0011AA\u000b\u0003-\u0019XM\u001d<fe\u000eC\u0017-\u001b8\u0016\u0005\u0005]\u0001CB\u0007\u0002\u0002\u0005e1\t\u0005\u0004\u000e\u00037\u0001\u0017qD\u0005\u0004\u0003;q!A\u0002+va2,'\u0007\u0005\u0003\u0002\"\u0005=RBAA\u0012\u0015\u0011\t)#a\n\u0002\rAd\u0017-_3s\u0015\u0011\tI#a\u000b\u0002\r\u0015tG/\u001b;z\u0015\r\ti\u0003C\u0001\n[&tWm\u0019:bMRLA!!\r\u0002$\tqQI\u001c;jif\u0004F.Y=fe6\u0003\u0006\"CA\u001b\u0001\u0001\u0007I\u0011AA\u001c\u0003=\u0019XM\u001d<fe\u000eC\u0017-\u001b8`I\u0015\fHcA\"\u0002:!Iq)a\r\u0002\u0002\u0003\u0007\u0011q\u0003\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002\u0018\u0005a1/\u001a:wKJ\u001c\u0005.Y5oA!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0013\u0001\u0005:fON+'O^3s\u0011\u0006tG\r\\3s)\r\u0019\u0015Q\t\u0005\t\u0003\u000f\ny\u00041\u0001\u0002\u0018\u0005\ta\rC\u0004\u0002L\u0001!\t!!\u0014\u0002!I,wm\u00117jK:$\b*\u00198eY\u0016\u0014HcA\"\u0002P!9\u0011qIA%\u0001\u0004y\bbBA*\u0001\u0011%\u0011QK\u0001\u000bC\u0012$\u0007*\u00198eY\u0016\u0014H#B\"\u0002X\u0005m\u0003bBA-\u0003#\u0002\raL\u0001\u0005g&$W\r\u0003\u0005\u0002^\u0005E\u0003\u0019AA0\u0003\u001dA\u0017M\u001c3mKJ\u00042aVA1\u0013\r\t\u0019\u0007\u0017\u0002\u000f\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0011\u001d\t9\u0007\u0001C\u0001\u0003S\n\u0011b]3oIR{\u0017\t\u001c7\u0015\u0007\r\u000bY\u0007C\u0004\u0002n\u0005\u0015\u0004\u0019\u00011\u0002\u000f5,7o]1hK\"9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0014AB:f]\u0012$v\u000eF\u0003D\u0003k\n9\bC\u0004\u0002n\u0005=\u0004\u0019\u00011\t\u0011\u0005\u0015\u0012q\u000ea\u0001\u0003?Aq!a\u001f\u0001\t\u0003\ti(A\btK:$Gk\\!mY\u0006\u0013x.\u001e8e)\u0015\u0019\u0015qPAA\u0011\u001d\ti'!\u001fA\u0002\u0001D\u0001\"a!\u0002z\u0001\u0007\u0011QQ\u0001\u0006a>Lg\u000e\u001e\t\u0005\u0003\u000f\u000biID\u0002;\u0003\u0013K1!a#<\u0003=qU\r^<pe.\u0014VmZ5tiJL\u0018\u0002BAH\u0003#\u00131\u0002V1sO\u0016$\bk\\5oi*\u0019\u00111R\u001e\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\u0006y1/\u001a8e)>$\u0015.\\3og&|g\u000eF\u0003D\u00033\u000bY\nC\u0004\u0002n\u0005M\u0005\u0019\u00011\t\u0011\u0005u\u00151\u0013a\u0001\u0003?\u000b1\u0002Z5nK:\u001c\u0018n\u001c8JIB\u0019Q\"!)\n\u0007\u0005\rfBA\u0002J]RDq!a*\u0001\t\u0003\tI+\u0001\u0007tK:$Gk\\*feZ,'\u000fF\u0002D\u0003WCq!!\u001c\u0002&\u0002\u0007\u0001\r")
public class NetChannel {
    private final String name;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private PartialFunction<BaseMessage<NetChannel>, BoxedUnit> clientChain;
    private PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> serverChain;
    private volatile NetChannel$ServerHandler$ ServerHandler$module;
    private volatile NetChannel$ClientHandler$ ClientHandler$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetChannel$ServerHandler$ ServerHandler$lzycompute() {
        NetChannel netChannel = this;
        synchronized (netChannel) {
            if (this.ServerHandler$module != null) return this.ServerHandler$module;
            this.ServerHandler$module = new NetChannel$ServerHandler$(this);
            return this.ServerHandler$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetChannel$ClientHandler$ ClientHandler$lzycompute() {
        NetChannel netChannel = this;
        synchronized (netChannel) {
            if (this.ClientHandler$module != null) return this.ClientHandler$module;
            this.ClientHandler$module = new NetChannel$ClientHandler$(this);
            return this.ClientHandler$module;
        }
    }

    public String name() {
        return this.name;
    }

    public EnumMap<Side, FMLEmbeddedChannel> channels() {
        return this.channels;
    }

    public void channels_$eq(EnumMap<Side, FMLEmbeddedChannel> x$1) {
        this.channels = x$1;
    }

    public NetChannel$ServerHandler$ ServerHandler() {
        return this.ServerHandler$module == null ? this.ServerHandler$lzycompute() : this.ServerHandler$module;
    }

    public NetChannel$ClientHandler$ ClientHandler() {
        return this.ClientHandler$module == null ? this.ClientHandler$lzycompute() : this.ClientHandler$module;
    }

    public void init() {
        if (this.channels() == null) {
            this.channels_$eq(NetworkRegistry.INSTANCE.newChannel(this.name(), new ChannelHandler[]{new SerializedMessageCodec()}));
            BdLib$.MODULE$.logInfo("Initialized network channel '%s' for mod '%s'", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), Misc$.MODULE$.getActiveModId()}));
            this.addHandler(Side.SERVER, (ChannelHandler)this.ServerHandler());
            this.addHandler(Side.CLIENT, (ChannelHandler)this.ClientHandler());
            return;
        }
        throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Attempted to initialize a channel twice (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
    }

    public PartialFunction<BaseMessage<NetChannel>, BoxedUnit> clientChain() {
        return this.clientChain;
    }

    public void clientChain_$eq(PartialFunction<BaseMessage<NetChannel>, BoxedUnit> x$1) {
        this.clientChain = x$1;
    }

    public PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> serverChain() {
        return this.serverChain;
    }

    public void serverChain_$eq(PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> x$1) {
        this.serverChain = x$1;
    }

    public void regServerHandler(PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> f) {
        this.serverChain_$eq((PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit>)this.serverChain().orElse(f));
    }

    public void regClientHandler(PartialFunction<BaseMessage<NetChannel>, BoxedUnit> f) {
        this.clientChain_$eq((PartialFunction<BaseMessage<NetChannel>, BoxedUnit>)this.clientChain().orElse(f));
    }

    private void addHandler(Side side, ChannelHandler handler) {
        FMLEmbeddedChannel ch = this.channels().get(side);
        String name = ch.findChannelHandlerNameForType(SerializedMessageCodec.class);
        ch.pipeline().addAfter(name, Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)side), "Handler"), handler);
    }

    public void sendToAll(BaseMessage<NetChannel> message) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(BaseMessage<NetChannel> message, EntityPlayerMP player) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(BaseMessage<NetChannel> message, NetworkRegistry.TargetPoint point) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(BaseMessage<NetChannel> message, int dimensionId) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new Integer(dimensionId));
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(BaseMessage<NetChannel> message) {
        ((DefaultAttributeMap)this.channels().get(Side.CLIENT)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        ((AbstractChannel)this.channels().get(Side.CLIENT)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public NetChannel(String name) {
        this.name = name;
        this.clientChain = PartialFunction$.MODULE$.empty();
        this.serverChain = PartialFunction$.MODULE$.empty();
    }
}

